/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.spider;

import java.util.Map;
import java.util.Random;
import org.apache.sedona.common.spider.BitGenerator;
import org.apache.sedona.common.spider.DiagonalGenerator;
import org.apache.sedona.common.spider.GaussianGenerator;
import org.apache.sedona.common.spider.Generator;
import org.apache.sedona.common.spider.ParcelGenerator;
import org.apache.sedona.common.spider.PointBasedGenerator;
import org.apache.sedona.common.spider.SierpinskiGenerator;
import org.apache.sedona.common.spider.UniformGenerator;

public class GeneratorFactory {
    private GeneratorFactory() {
    }

    public static Generator create(String name, Random random, Map<String, String> parameters) {
        switch (name) {
            case "uniform": {
                return new UniformGenerator(random, PointBasedGenerator.PointBasedParameter.create(parameters));
            }
            case "gaussian": {
                return new GaussianGenerator(random, PointBasedGenerator.PointBasedParameter.create(parameters));
            }
            case "diagonal": {
                return new DiagonalGenerator(random, DiagonalGenerator.DiagonalParameter.create(parameters));
            }
            case "bit": {
                return new BitGenerator(random, BitGenerator.BitParameter.create(parameters));
            }
            case "sierpinski": {
                return new SierpinskiGenerator(random, PointBasedGenerator.PointBasedParameter.create(parameters));
            }
            case "parcel": {
                return new ParcelGenerator(random, ParcelGenerator.ParcelParameter.create(parameters));
            }
        }
        throw new IllegalArgumentException("Unknown generator: " + name);
    }
}

