/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft;

import java.io.IOException;
import java.util.Formatter;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactory;
import ucar.nc2.ft2.coverage.adapter.DtCoverageCSBuilder;
import ucar.nc2.util.CancelTask;

public class GridDatasetStandardFactory
implements FeatureDatasetFactory {
    @Override
    public Object isMine(FeatureType wantFeatureType, NetcdfDataset ncd, Formatter errlog) {
        DtCoverageCSBuilder dtCoverage = DtCoverageCSBuilder.classify(ncd, errlog);
        if (dtCoverage == null || dtCoverage.getCoverageType() == null) {
            return null;
        }
        if (!this.match(wantFeatureType, dtCoverage.getCoverageType())) {
            return null;
        }
        return dtCoverage;
    }

    private boolean match(FeatureType wantFeatureType, FeatureType covType) {
        if (wantFeatureType == null || wantFeatureType == FeatureType.ANY) {
            return true;
        }
        return true;
    }

    @Override
    public FeatureDataset open(FeatureType ftype, NetcdfDataset ncd, Object analysis, CancelTask task, Formatter errlog) throws IOException {
        return new GridDataset(ncd);
    }

    @Override
    public FeatureType[] getFeatureTypes() {
        return new FeatureType[]{FeatureType.GRID, FeatureType.FMRC, FeatureType.SWATH};
    }
}

