/*
 * Decompiled with CFR 0.152.
 */
package net.sf.geographiclib;

import net.sf.geographiclib.GeoMath;
import net.sf.geographiclib.Pair;

public class Accumulator {
    private double _s;
    private double _t;

    public Accumulator(double y) {
        this._s = y;
        this._t = 0.0;
    }

    public Accumulator(Accumulator a) {
        this._s = a._s;
        this._t = a._t;
    }

    public void Set(double y) {
        this._s = y;
        this._t = 0.0;
    }

    public double Sum() {
        return this._s;
    }

    public double Sum(double y) {
        Pair p = new Pair();
        Accumulator.AddInternal(p, this._s, this._t, y);
        return p.first;
    }

    public static void AddInternal(Pair p, double s2, double t, double y) {
        GeoMath.sum(p, y, t);
        y = p.first;
        double u = p.second;
        GeoMath.sum(p, y, s2);
        s2 = p.first;
        t = p.second;
        if (s2 == 0.0) {
            s2 = u;
        } else {
            t += u;
        }
        p.first = s2;
        p.second = t;
    }

    public void Add(double y) {
        Pair p = new Pair();
        Accumulator.AddInternal(p, this._s, this._t, y);
        this._s = p.first;
        this._t = p.second;
    }

    public void Negate() {
        this._s = -this._s;
        this._t = -this._t;
    }

    public void Remainder(double y) {
        this._s = GeoMath.remainder(this._s, y);
        this.Add(0.0);
    }
}

