/*
 * Decompiled with CFR 0.152.
 */
package net.sf.geographiclib;

import net.sf.geographiclib.GeoMath;
import net.sf.geographiclib.Geodesic;
import net.sf.geographiclib.GeodesicData;
import net.sf.geographiclib.Pair;

public class GeodesicLine {
    private static final int nC1_ = 6;
    private static final int nC1p_ = 6;
    private static final int nC2_ = 6;
    private static final int nC3_ = 6;
    private static final int nC4_ = 6;
    private double _lat1;
    private double _lon1;
    private double _azi1;
    private double _a;
    private double _f;
    private double _b;
    private double _c2;
    private double _f1;
    private double _salp0;
    private double _calp0;
    private double _k2;
    private double _salp1;
    private double _calp1;
    private double _ssig1;
    private double _csig1;
    private double _dn1;
    private double _stau1;
    private double _ctau1;
    private double _somg1;
    private double _comg1;
    private double _A1m1;
    private double _A2m1;
    private double _A3c;
    private double _B11;
    private double _B21;
    private double _B31;
    private double _A4;
    private double _B41;
    private double _a13;
    private double _s13;
    private double[] _C1a;
    private double[] _C1pa;
    private double[] _C2a;
    private double[] _C3a;
    private double[] _C4a;
    private int _caps;

    public GeodesicLine(Geodesic g2, double lat1, double lon1, double azi1) {
        this(g2, lat1, lon1, azi1, 32671);
    }

    public GeodesicLine(Geodesic g2, double lat1, double lon1, double azi1, int caps) {
        azi1 = GeoMath.AngNormalize(azi1);
        Pair p = new Pair();
        GeoMath.sincosd(p, GeoMath.AngRound(azi1));
        double salp1 = p.first;
        double calp1 = p.second;
        this.LineInit(g2, lat1, lon1, azi1, salp1, calp1, caps, p);
    }

    private void LineInit(Geodesic g2, double lat1, double lon1, double azi1, double salp1, double calp1, int caps, Pair p) {
        this._a = g2._a;
        this._f = g2._f;
        this._b = g2._b;
        this._c2 = g2._c2;
        this._f1 = g2._f1;
        this._caps = caps | 0x80 | 0x200 | 0x8000;
        this._lat1 = GeoMath.LatFix(lat1);
        this._lon1 = lon1;
        this._azi1 = azi1;
        this._salp1 = salp1;
        this._calp1 = calp1;
        GeoMath.sincosd(p, GeoMath.AngRound(this._lat1));
        double sbet1 = this._f1 * p.first;
        double cbet1 = p.second;
        GeoMath.norm(p, sbet1, cbet1);
        sbet1 = p.first;
        cbet1 = Math.max(Geodesic.tiny_, p.second);
        this._dn1 = Math.sqrt(1.0 + g2._ep2 * GeoMath.sq(sbet1));
        this._salp0 = this._salp1 * cbet1;
        this._calp0 = Math.hypot(this._calp1, this._salp1 * sbet1);
        this._ssig1 = sbet1;
        this._somg1 = this._salp0 * sbet1;
        this._comg1 = sbet1 != 0.0 || this._calp1 != 0.0 ? cbet1 * this._calp1 : 1.0;
        this._csig1 = this._comg1;
        GeoMath.norm(p, this._ssig1, this._csig1);
        this._ssig1 = p.first;
        this._csig1 = p.second;
        this._k2 = GeoMath.sq(this._calp0) * g2._ep2;
        double eps = this._k2 / (2.0 * (1.0 + Math.sqrt(1.0 + this._k2)) + this._k2);
        if ((this._caps & 1) != 0) {
            this._A1m1 = Geodesic.A1m1f(eps);
            this._C1a = new double[7];
            Geodesic.C1f(eps, this._C1a);
            this._B11 = Geodesic.SinCosSeries(true, this._ssig1, this._csig1, this._C1a);
            double s2 = Math.sin(this._B11);
            double c = Math.cos(this._B11);
            this._stau1 = this._ssig1 * c + this._csig1 * s2;
            this._ctau1 = this._csig1 * c - this._ssig1 * s2;
        }
        if ((this._caps & 2) != 0) {
            this._C1pa = new double[7];
            Geodesic.C1pf(eps, this._C1pa);
        }
        if ((this._caps & 4) != 0) {
            this._C2a = new double[7];
            this._A2m1 = Geodesic.A2m1f(eps);
            Geodesic.C2f(eps, this._C2a);
            this._B21 = Geodesic.SinCosSeries(true, this._ssig1, this._csig1, this._C2a);
        }
        if ((this._caps & 8) != 0) {
            this._C3a = new double[6];
            g2.C3f(eps, this._C3a);
            this._A3c = -this._f * this._salp0 * g2.A3f(eps);
            this._B31 = Geodesic.SinCosSeries(true, this._ssig1, this._csig1, this._C3a);
        }
        if ((this._caps & 0x10) != 0) {
            this._C4a = new double[6];
            g2.C4f(eps, this._C4a);
            this._A4 = GeoMath.sq(this._a) * this._calp0 * this._salp0 * g2._e2;
            this._B41 = Geodesic.SinCosSeries(false, this._ssig1, this._csig1, this._C4a);
        }
    }

    protected GeodesicLine(Geodesic g2, double lat1, double lon1, double azi1, double salp1, double calp1, int caps, boolean arcmode, double s13_a13) {
        Pair p = new Pair();
        this.LineInit(g2, lat1, lon1, azi1, salp1, calp1, caps, p);
        this.GenSetDistance(arcmode, s13_a13);
    }

    private GeodesicLine() {
        this._caps = 0;
    }

    public GeodesicData Position(double s12) {
        return this.Position(false, s12, 1929);
    }

    public GeodesicData Position(double s12, int outmask) {
        return this.Position(false, s12, outmask);
    }

    public GeodesicData ArcPosition(double a12) {
        return this.Position(true, a12, 1929);
    }

    public GeodesicData ArcPosition(double a12, int outmask) {
        return this.Position(true, a12, outmask);
    }

    public GeodesicData Position(boolean arcmode, double s12_a12, int outmask) {
        double csig12;
        double ssig12;
        double sig12;
        outmask &= this._caps & 0xFF80;
        GeodesicData r = new GeodesicData();
        if (!this.Init() || !arcmode && (this._caps & 0x800) == 0) {
            return r;
        }
        r.lat1 = this._lat1;
        r.azi1 = this._azi1;
        r.lon1 = (outmask & 0x8000) != 0 ? this._lon1 : GeoMath.AngNormalize(this._lon1);
        double B12 = 0.0;
        double AB1 = 0.0;
        if (arcmode) {
            r.a12 = s12_a12;
            sig12 = Math.toRadians(s12_a12);
            Pair p = new Pair();
            GeoMath.sincosd(p, s12_a12);
            ssig12 = p.first;
            csig12 = p.second;
        } else {
            r.s12 = s12_a12;
            double tau12 = s12_a12 / (this._b * (1.0 + this._A1m1));
            double s2 = Math.sin(tau12);
            double c = Math.cos(tau12);
            B12 = -Geodesic.SinCosSeries(true, this._stau1 * c + this._ctau1 * s2, this._ctau1 * c - this._stau1 * s2, this._C1pa);
            sig12 = tau12 - (B12 - this._B11);
            ssig12 = Math.sin(sig12);
            csig12 = Math.cos(sig12);
            if (Math.abs(this._f) > 0.01) {
                double ssig2 = this._ssig1 * csig12 + this._csig1 * ssig12;
                double csig2 = this._csig1 * csig12 - this._ssig1 * ssig12;
                B12 = Geodesic.SinCosSeries(true, ssig2, csig2, this._C1a);
                double serr = (1.0 + this._A1m1) * (sig12 + (B12 - this._B11)) - s12_a12 / this._b;
                ssig12 = Math.sin(sig12 -= serr / Math.sqrt(1.0 + this._k2 * GeoMath.sq(ssig2)));
                csig12 = Math.cos(sig12);
            }
            r.a12 = Math.toDegrees(sig12);
        }
        double ssig2 = this._ssig1 * csig12 + this._csig1 * ssig12;
        double csig2 = this._csig1 * csig12 - this._ssig1 * ssig12;
        double dn2 = Math.sqrt(1.0 + this._k2 * GeoMath.sq(ssig2));
        if ((outmask & 0x3405) != 0) {
            if (arcmode || Math.abs(this._f) > 0.01) {
                B12 = Geodesic.SinCosSeries(true, ssig2, csig2, this._C1a);
            }
            AB1 = (1.0 + this._A1m1) * (B12 - this._B11);
        }
        double sbet2 = this._calp0 * ssig2;
        double cbet2 = Math.hypot(this._salp0, this._calp0 * csig2);
        if (cbet2 == 0.0) {
            cbet2 = csig2 = Geodesic.tiny_;
        }
        double salp2 = this._salp0;
        double calp2 = this._calp0 * csig2;
        if ((outmask & 0x401) != 0 && arcmode) {
            r.s12 = this._b * ((1.0 + this._A1m1) * sig12 + AB1);
        }
        if ((outmask & 0x108) != 0) {
            double somg2 = this._salp0 * ssig2;
            double comg2 = csig2;
            double E = Math.copySign(1.0, this._salp0);
            double omg12 = (outmask & 0x8000) != 0 ? E * (sig12 - (Math.atan2(ssig2, csig2) - Math.atan2(this._ssig1, this._csig1)) + (Math.atan2(E * somg2, comg2) - Math.atan2(E * this._somg1, this._comg1))) : Math.atan2(somg2 * this._comg1 - comg2 * this._somg1, comg2 * this._comg1 + somg2 * this._somg1);
            double lam12 = omg12 + this._A3c * (sig12 + (Geodesic.SinCosSeries(true, ssig2, csig2, this._C3a) - this._B31));
            double lon12 = Math.toDegrees(lam12);
            double d = r.lon2 = (outmask & 0x8000) != 0 ? this._lon1 + lon12 : GeoMath.AngNormalize(r.lon1 + GeoMath.AngNormalize(lon12));
        }
        if ((outmask & 0x80) != 0) {
            r.lat2 = GeoMath.atan2d(sbet2, this._f1 * cbet2);
        }
        if ((outmask & 0x200) != 0) {
            r.azi2 = GeoMath.atan2d(salp2, calp2);
        }
        if ((outmask & 0x3005) != 0) {
            double B22 = Geodesic.SinCosSeries(true, ssig2, csig2, this._C2a);
            double AB2 = (1.0 + this._A2m1) * (B22 - this._B21);
            double J12 = (this._A1m1 - this._A2m1) * sig12 + (AB1 - AB2);
            if ((outmask & 0x1005) != 0) {
                r.m12 = this._b * (dn2 * (this._csig1 * ssig2) - this._dn1 * (this._ssig1 * csig2) - this._csig1 * csig2 * J12);
            }
            if ((outmask & 0x2005) != 0) {
                double t = this._k2 * (ssig2 - this._ssig1) * (ssig2 + this._ssig1) / (this._dn1 + dn2);
                r.M12 = csig12 + (t * ssig2 - csig2 * J12) * this._ssig1 / this._dn1;
                r.M21 = csig12 - (t * this._ssig1 - this._csig1 * J12) * ssig2 / dn2;
            }
        }
        if ((outmask & 0x4010) != 0) {
            double calp12;
            double salp12;
            double B42 = Geodesic.SinCosSeries(false, ssig2, csig2, this._C4a);
            if (this._calp0 == 0.0 || this._salp0 == 0.0) {
                salp12 = salp2 * this._calp1 - calp2 * this._salp1;
                calp12 = calp2 * this._calp1 + salp2 * this._salp1;
            } else {
                salp12 = this._calp0 * this._salp0 * (csig12 <= 0.0 ? this._csig1 * (1.0 - csig12) + ssig12 * this._ssig1 : ssig12 * (this._csig1 * ssig12 / (1.0 + csig12) + this._ssig1));
                calp12 = GeoMath.sq(this._salp0) + GeoMath.sq(this._calp0) * this._csig1 * csig2;
            }
            r.S12 = this._c2 * Math.atan2(salp12, calp12) + this._A4 * (B42 - this._B41);
        }
        return r;
    }

    public void SetDistance(double s13) {
        this._s13 = s13;
        GeodesicData g2 = this.Position(false, this._s13, 0);
        this._a13 = g2.a12;
    }

    void SetArc(double a13) {
        this._a13 = a13;
        GeodesicData g2 = this.Position(true, this._a13, 1025);
        this._s13 = g2.s12;
    }

    public void GenSetDistance(boolean arcmode, double s13_a13) {
        if (arcmode) {
            this.SetArc(s13_a13);
        } else {
            this.SetDistance(s13_a13);
        }
    }

    private boolean Init() {
        return this._caps != 0;
    }

    public double Latitude() {
        return this.Init() ? this._lat1 : Double.NaN;
    }

    public double Longitude() {
        return this.Init() ? this._lon1 : Double.NaN;
    }

    public double Azimuth() {
        return this.Init() ? this._azi1 : Double.NaN;
    }

    public Pair AzimuthCosines() {
        return new Pair(this.Init() ? this._salp1 : Double.NaN, this.Init() ? this._calp1 : Double.NaN);
    }

    public double EquatorialAzimuth() {
        return this.Init() ? GeoMath.atan2d(this._salp0, this._calp0) : Double.NaN;
    }

    public Pair EquatorialAzimuthCosines() {
        return new Pair(this.Init() ? this._salp0 : Double.NaN, this.Init() ? this._calp0 : Double.NaN);
    }

    public double EquatorialArc() {
        return this.Init() ? GeoMath.atan2d(this._ssig1, this._csig1) : Double.NaN;
    }

    public double EquatorialRadius() {
        return this.Init() ? this._a : Double.NaN;
    }

    public double Flattening() {
        return this.Init() ? this._f : Double.NaN;
    }

    public int Capabilities() {
        return this._caps;
    }

    public boolean Capabilities(int testcaps) {
        return (this._caps & (testcaps &= 0x7F80)) == testcaps;
    }

    public double GenDistance(boolean arcmode) {
        return this.Init() ? (arcmode ? this._a13 : this._s13) : Double.NaN;
    }

    public double Distance() {
        return this.GenDistance(false);
    }

    public double Arc() {
        return this.GenDistance(true);
    }

    @Deprecated
    public double MajorRadius() {
        return this.EquatorialRadius();
    }
}

