/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.raster;

import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.sedona_sql.io.raster.RasterOptions;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005i4Aa\u0004\t\u0005?!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011!Y\u0004A!A!\u0002\u0013a\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u000b-\u0003A\u0011\u0001'\t\u000fI\u0003!\u0019!C\u0005'\"1!\f\u0001Q\u0001\nQCqa\u0017\u0001C\u0002\u0013%A\f\u0003\u0004b\u0001\u0001\u0006I!\u0018\u0005\u0006E\u0002!I\u0001\u0018\u0005\u0006G\u0002!\t\u0005\u001a\u0005\u0006a\u0002!\t%\u001d\u0005\u0006e\u0002!\ta\u001d\u0005\u0006i\u0002!I!\u001e\u0002\u0011%\u0006\u001cH/\u001a:GS2,wK]5uKJT!!\u0005\n\u0002\rI\f7\u000f^3s\u0015\t\u0019B#\u0001\u0002j_*\u0011QCF\u0001\u000bg\u0016$wN\\1`gFd'BA\f\u0019\u0003\r\u0019\u0018\u000f\u001c\u0006\u00033i\tQa\u001d9be.T!a\u0007\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0012aA8sO\u000e\u00011C\u0001\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0013\u0017\u0003%)\u00070Z2vi&|g.\u0003\u0002(E\taq*\u001e;qkR<&/\u001b;fe\u0006A1/\u0019<f!\u0006$\b\u000e\u0005\u0002+g9\u00111&\r\t\u0003Y=j\u0011!\f\u0006\u0003]y\ta\u0001\u0010:p_Rt$\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz\u0013A\u0002)sK\u0012,g-\u0003\u00025k\t11\u000b\u001e:j]\u001eT!AM\u0018\u0002\u001bI\f7\u000f^3s\u001fB$\u0018n\u001c8t!\tA\u0014(D\u0001\u0011\u0013\tQ\u0004CA\u0007SCN$XM](qi&|gn]\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007CA\u001fA\u001b\u0005q$BA \u0017\u0003\u0015!\u0018\u0010]3t\u0013\t\teH\u0001\u0006TiJ,8\r\u001e+za\u0016\fqaY8oi\u0016DH\u000f\u0005\u0002E\u00136\tQI\u0003\u0002G\u000f\u0006IQ.\u00199sK\u0012,8-\u001a\u0006\u0003\u0011j\ta\u0001[1e_>\u0004\u0018B\u0001&F\u0005I!\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0015iej\u0014)R!\tA\u0004\u0001C\u0003)\u000b\u0001\u0007\u0011\u0006C\u00037\u000b\u0001\u0007q\u0007C\u0003<\u000b\u0001\u0007A\bC\u0003C\u000b\u0001\u00071)A\u0002iMN,\u0012\u0001\u0016\t\u0003+bk\u0011A\u0016\u0006\u0003/\u001e\u000b!AZ:\n\u0005e3&A\u0003$jY\u0016\u001c\u0016p\u001d;f[\u0006!\u0001NZ:!\u0003A\u0011\u0018m\u001d;fe\u001aKW\r\u001c3J]\u0012,\u00070F\u0001^!\tqv,D\u00010\u0013\t\u0001wFA\u0002J]R\f\u0011C]1ti\u0016\u0014h)[3mI&sG-\u001a=!\u0003M9W\r\u001e*bgR,'OR5fY\u0012Le\u000eZ3y\u0003\u00159(/\u001b;f)\t)\u0007\u000e\u0005\u0002_M&\u0011qm\f\u0002\u0005+:LG\u000fC\u0003j\u0017\u0001\u0007!.A\u0002s_^\u0004\"a\u001b8\u000e\u00031T!!\u001c\f\u0002\u0011\r\fG/\u00197zgRL!a\u001c7\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u0006G2|7/\u001a\u000b\u0002K\u0006!\u0001/\u0019;i)\u0005I\u0013!E4fiJ\u000b7\u000f^3s\r&dW\rU1uQR!\u0011F^<z\u0011\u0015Ig\u00021\u0001k\u0011\u0015Ah\u00021\u0001=\u0003\u0019\u00198\r[3nC\")aG\u0004a\u0001o\u0001")
public class RasterFileWriter
extends OutputWriter {
    private final String savePath;
    private final RasterOptions rasterOptions;
    private final StructType dataSchema;
    private final FileSystem hfs;
    private final int rasterFieldIndex;

    private FileSystem hfs() {
        return this.hfs;
    }

    private int rasterFieldIndex() {
        return this.rasterFieldIndex;
    }

    private int getRasterFieldIndex() {
        StructType schemaFields = this.dataSchema;
        IntRef curField = IntRef.create((int)-1);
        schemaFields.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            if (schemaFields.fields()[i].dataType().typeName().equals("binary")) {
                curField$1.elem = i;
                return;
            }
        });
        return curField.elem;
    }

    public void write(InternalRow row) {
        byte[] rasterRaw = row.getBinary(this.rasterFieldIndex());
        if (rasterRaw == null) {
            return;
        }
        String rasterFilePath = this.getRasterFilePath(row, this.dataSchema, this.rasterOptions);
        try {
            FSDataOutputStream out = this.hfs().create(new Path(this.savePath, new Path(rasterFilePath).getName()));
            out.write(rasterRaw);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
    }

    public String path() {
        return this.savePath;
    }

    private String getRasterFilePath(InternalRow row, StructType schema, RasterOptions rasterOptions) {
        String rasterFilePathRaw;
        String rasterFilePath = UUID.randomUUID().toString();
        if (rasterOptions.rasterPathField().isDefined() && (rasterFilePathRaw = row.getString(schema.fieldIndex((String)rasterOptions.rasterPathField().get()))) != null) {
            rasterFilePath = rasterFilePathRaw.contains(".") ? rasterFilePathRaw.substring(0, rasterFilePathRaw.lastIndexOf(".")) : rasterFilePathRaw;
        }
        return new StringBuilder(0).append(rasterFilePath).append(rasterOptions.fileExtension()).toString();
    }

    public RasterFileWriter(String savePath, RasterOptions rasterOptions, StructType dataSchema, TaskAttemptContext context) {
        this.savePath = savePath;
        this.rasterOptions = rasterOptions;
        this.dataSchema = dataSchema;
        this.hfs = new Path(savePath).getFileSystem(context.getConfiguration());
        this.rasterFieldIndex = rasterOptions.rasterField().isEmpty() ? this.getRasterFieldIndex() : dataSchema.fieldIndex((String)rasterOptions.rasterField().get());
    }
}

