/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.stac;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.Serializable;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.sedona_sql.io.stac.StacTable$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.LinearSeqOps;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

public final class StacUtils$ {
    public static final StacUtils$ MODULE$ = new StacUtils$();

    public String loadStacCollectionToJson(scala.collection.immutable.Map<String, String> opts) {
        String urlFull = this.getFullCollectionUrl(opts);
        return this.loadStacCollectionToJson(urlFull, this.loadStacCollectionToJson$default$2());
    }

    public String getFullCollectionUrl(scala.collection.immutable.Map<String, String> opts) {
        String url = (String)opts.getOrElse((Object)"path", (Function0 & Serializable)() -> (String)opts.getOrElse((Object)"service", (Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Either 'path' or 'service' must be provided");
        }));
        String urlFinal = url.matches("^[a-zA-Z][a-zA-Z0-9+.-]*://.*") ? url : new StringBuilder(7).append("file://").append(url).toString();
        return urlFinal;
    }

    public String loadStacCollectionToJson(String url, int maxRetries) {
        int retries = 0;
        boolean success = false;
        String result = "";
        while (retries < maxRetries && !success) {
            try {
                result = url.startsWith("s3://") || url.startsWith("s3a://") ? Predef$.MODULE$.wrapRefArray((Object[])SparkSession$.MODULE$.active().read().textFile(url).collect()).mkString("\n") : Source$.MODULE$.fromURL(url, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                success = true;
            }
            catch (Exception e) {
                if (++retries < maxRetries) continue;
                throw new RuntimeException(new StringBuilder(52).append("Failed to load STAC collection from ").append(url).append(" after ").append(maxRetries).append(" attempts").toString(), e);
            }
        }
        return result;
    }

    public int loadStacCollectionToJson$default$2() {
        return 3;
    }

    public String getStacCollectionBasePath(scala.collection.immutable.Map<String, String> opts) {
        String ref = (String)opts.getOrElse((Object)"path", (Function0 & Serializable)() -> (String)opts.getOrElse((Object)"service", (Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Either 'path' or 'service' must be provided");
        }));
        return this.getStacCollectionBasePath(ref);
    }

    public String getStacCollectionBasePath(String collectionUrl) {
        Option option;
        Option option2;
        Regex urlPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(https?://[^/]+/|http://[^/]+/).*"));
        Regex filePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(file:///.*/|/.*/).*"));
        String string = collectionUrl;
        if (string != null && !(option2 = urlPattern.unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
            String baseUrl = (String)((LinearSeqOps)option2.get()).apply(0);
            return baseUrl;
        }
        if (string != null && !(option = filePattern.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String basePath = (String)((LinearSeqOps)option.get()).apply(0);
            if (basePath.startsWith("file://")) {
                return basePath;
            }
            return new StringBuilder(7).append("file://").append(basePath).toString();
        }
        throw new IllegalArgumentException(new StringBuilder(26).append("Invalid URL or file path: ").append(collectionUrl).toString());
    }

    public StructType inferStacSchema(scala.collection.immutable.Map<String, String> opts) {
        String stacVersion;
        String stacCollectionJsonString = this.loadStacCollectionToJson(opts);
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        JsonNode collection = mapper.readTree(stacCollectionJsonString);
        String string = stacVersion = collection.get("stac_version").asText();
        switch (string == null ? 0 : string.hashCode()) {
            case 46670517: {
                if (!"1.0.0".equals(string)) break;
                return StacTable$.MODULE$.SCHEMA_V1_0_0();
            }
        }
        if (string.matches("1\\.[1-9]\\d*\\.\\d*")) {
            return StacTable$.MODULE$.SCHEMA_V1_1_0();
        }
        throw new IllegalArgumentException(new StringBuilder(26).append("Unsupported STAC version: ").append(stacVersion).toString());
    }

    public InternalRow promotePropertiesToTop(InternalRow row, StructType schema) {
        int propertiesIndex = schema.fieldIndex("properties");
        StructType propertiesStruct = (StructType)schema.apply("properties").dataType();
        InternalRow propertiesRow = row.getStruct(propertiesIndex, propertiesStruct.fields().length);
        Seq newValues = (Seq)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()))), (Object)package$.MODULE$.Seq().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Seq acc = (Seq)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    StructField field = (StructField)tuple22._1();
                    String string = field.name();
                    String string2 = "properties";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return (Seq)acc.$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])propertiesStruct.fields()))), (Function1 & Serializable)x0$2 -> {
                            Tuple2 tuple2 = x0$2;
                            if (tuple2 != null) {
                                StructField propField = (StructField)tuple2._1();
                                int propIndex = tuple2._2$mcI$sp();
                                return propertiesRow.get(propIndex, propField.dataType());
                            }
                            throw new MatchError((Object)tuple2);
                        }, ClassTag$.MODULE$.apply(Object.class))));
                    }
                }
            }
            if (tuple2 != null) {
                Seq acc = (Seq)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple23 != null) {
                    int index = tuple23._2$mcI$sp();
                    return (Seq)acc.$colon$plus(row.get(index, schema.apply(index).dataType()));
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return InternalRow$.MODULE$.fromSeq(newValues);
    }

    public StructType updatePropertiesPromotedSchema(StructType schema) {
        int propertiesIndex = schema.fieldIndex("properties");
        StructType propertiesStruct = (StructType)schema.apply("properties").dataType();
        Seq newFields = (Seq)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Object)package$.MODULE$.Seq().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                String string;
                Seq acc = (Seq)tuple2._1();
                StructField structField = (StructField)tuple2._2();
                if (structField != null && "properties".equals(string = structField.name())) {
                    return (Seq)acc.$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])propertiesStruct.fields()));
                }
            }
            if (tuple2 != null) {
                Seq acc = (Seq)tuple2._1();
                StructField other = (StructField)tuple2._2();
                return (Seq)acc.$colon$plus((Object)other);
            }
            throw new MatchError((Object)tuple2);
        });
        return StructType$.MODULE$.apply(newFields);
    }

    public InternalRow buildOutDbRasterFields(InternalRow row, StructType schema) {
        Object[] newValues = new Object[schema.fields().length];
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()))), (Function1 & Serializable)x0$1 -> {
            StacUtils$.$anonfun$buildOutDbRasterFields$1(row, newValues, schema, x0$1);
            return BoxedUnit.UNIT;
        });
        return InternalRow$.MODULE$.fromSeq((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)newValues));
    }

    public int getNumPartitions(int itemCount, int numPartitions, int maxPartitionItemFiles, int defaultParallelism) {
        if (numPartitions > 0) {
            return numPartitions;
        }
        int maxSplitFiles = maxPartitionItemFiles > 0 ? Math.min(maxPartitionItemFiles, (int)Math.ceil((double)itemCount / (double)defaultParallelism)) : (int)Math.ceil((double)itemCount / (double)defaultParallelism);
        return Math.max(1, (int)Math.ceil((double)itemCount / (double)maxSplitFiles));
    }

    public static final /* synthetic */ void $anonfun$buildOutDbRasterFields$1(InternalRow row$2, Object[] newValues$1, StructType schema$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField structField = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (structField != null) {
                String string = structField.name();
                DataType dataType = structField.dataType();
                if ("assets".equals(string) && dataType instanceof MapType) {
                    MapType mapType = (MapType)dataType;
                    DataType dataType2 = mapType.keyType();
                    DataType valueType = mapType.valueType();
                    if (StringType$.MODULE$.equals(dataType2) && valueType instanceof StructType) {
                        MapData assetsMap = row$2.getMap(index);
                        if (assetsMap != null) {
                            scala.collection.immutable.Map updatedAssets = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.genericArrayOps((Object)assetsMap.keyArray().array()), (IterableOnce)Predef$.MODULE$.genericWrapArray((Object)assetsMap.valueArray().array()))), (Function1 & Serializable)x0$2 -> {
                                Tuple2 tuple2 = x0$2;
                                if (tuple2 != null) {
                                    Object key = tuple2._1();
                                    Object value = tuple2._2();
                                    InternalRow assetRow = (InternalRow)value;
                                    if (assetRow != null) {
                                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)assetRow);
                                    }
                                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), null);
                                }
                                throw new MatchError((Object)tuple2);
                            }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                            newValues$1[index] = ArrayBasedMapData$.MODULE$.apply((Map)updatedAssets, ArrayBasedMapData$.MODULE$.apply$default$2(), ArrayBasedMapData$.MODULE$.apply$default$3());
                            return;
                        }
                        newValues$1[index] = null;
                        return;
                    }
                }
            }
        }
        if (tuple2 != null) {
            int index = tuple2._2$mcI$sp();
            newValues$1[index] = row$2.get(index, schema$2.fields()[index].dataType());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private StacUtils$() {
    }
}

