/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.servlet;

import java.util.List;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.servicecomb.common.rest.filter.HttpServerFilter;
import org.apache.servicecomb.core.CseContext;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.http.StandardHttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.StandardHttpServletResponseEx;
import org.apache.servicecomb.transport.rest.servlet.RestAsyncListener;
import org.apache.servicecomb.transport.rest.servlet.RestServletProducerInvocation;
import org.apache.servicecomb.transport.rest.servlet.ServletConfig;

public class ServletRestDispatcher {
    private RestAsyncListener restAsyncListener = new RestAsyncListener();
    private Transport transport;
    private List<HttpServerFilter> httpServerFilters = SPIServiceUtils.getSortedService(HttpServerFilter.class);

    public void service(HttpServletRequest request, HttpServletResponse response) {
        if (this.transport == null) {
            this.transport = CseContext.getInstance().getTransportManager().findTransport("rest");
        }
        AsyncContext asyncCtx = request.startAsync();
        asyncCtx.addListener((AsyncListener)this.restAsyncListener);
        asyncCtx.setTimeout(ServletConfig.getAsyncServletTimeout());
        StandardHttpServletRequestEx requestEx = new StandardHttpServletRequestEx(request);
        StandardHttpServletResponseEx responseEx = new StandardHttpServletResponseEx(response);
        RestServletProducerInvocation restProducerInvocation = new RestServletProducerInvocation();
        restProducerInvocation.invoke(this.transport, (HttpServletRequestEx)requestEx, (HttpServletResponseEx)responseEx, this.httpServerFilters);
    }
}

