/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.dashboard.monitor;

import io.netty.util.concurrent.DefaultThreadFactory;
import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.data.MonitorConstant;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.model.MonitorDataProvider;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.model.MonitorDataPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataFactory.class);
    private static final int CORE_SIZE = 1;
    private boolean hasStart = false;
    @Inject
    private List<MonitorDataProvider> dataProviders;
    @Inject
    private MonitorDataPublisher publisher;
    private ScheduledExecutorService executorService = null;

    public DataFactory() {
        DefaultThreadFactory threadFactory = new DefaultThreadFactory("monitor-datafactory");
        this.executorService = Executors.newScheduledThreadPool(1, (ThreadFactory)threadFactory);
    }

    public void setMonitorDataProviders(List<MonitorDataProvider> dataProviders) {
        this.dataProviders = dataProviders;
    }

    public void setMonitorDataPublisher(MonitorDataPublisher publisher) {
        this.publisher = publisher;
    }

    void start() {
        if (!this.hasStart) {
            this.publisher.init();
            StringBuilder sb = new StringBuilder();
            sb.append("Monitor data sender started. Configured data providers is {");
            for (MonitorDataProvider provider : this.dataProviders) {
                sb.append(provider.getClass().getName());
                sb.append(",");
            }
            sb.append("}");
            LOGGER.info(sb.toString());
            this.executorService.scheduleWithFixedDelay(() -> {
                try {
                    this.sendData();
                }
                catch (Throwable e) {
                    LOGGER.error("send monitor data error.", e);
                }
            }, MonitorConstant.getInterval(), MonitorConstant.getInterval(), TimeUnit.MILLISECONDS);
            this.hasStart = true;
        }
    }

    void sendData() {
        for (MonitorDataProvider provider : this.dataProviders) {
            if (!provider.enabled()) continue;
            this.publisher.publish(provider);
        }
    }
}

