/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator;

import io.swagger.v3.oas.models.OpenAPI;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerGeneratorFactory;
import org.apache.servicecomb.swagger.generator.core.SwaggerGeneratorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SwaggerGenerator {
    public static final Logger LOGGER = LoggerFactory.getLogger(SwaggerGenerator.class);

    public static OpenAPI generate(Class<?> cls) {
        return SwaggerGenerator.create(cls).generate();
    }

    public static SwaggerGenerator create(Class<?> cls) {
        List factories = SPIServiceUtils.getOrLoadSortedService(SwaggerGeneratorFactory.class);
        for (SwaggerGeneratorFactory factory : factories) {
            if (!factory.canProcess(cls)) continue;
            LOGGER.info("select [{}] for [{}] to generate schema.", (Object)factory.getClass().getName(), (Object)cls.getName());
            return factory.create(cls);
        }
        throw new IllegalStateException("impossible, must be bug. can not generate swagger for " + cls.getName());
    }

    public SwaggerGeneratorContext getSwaggerGeneratorContext();

    public void setBasePath(String var1);

    public void scanClassAnnotation();

    public OpenAPI generate();

    public Class<?> getClazz();

    public OpenAPI getOpenAPI();

    public void setHttpMethod(String var1);

    public void replaceMethodWhiteList(String ... var1);

    public <T extends OperationGenerator> T createOperationGenerator(Method var1);
}

