/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.renderer.text;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.Document;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Link;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.text.TextContentNodeRendererContext;
import org.commonmark.renderer.text.TextContentWriter;

public class CoreTextContentNodeRenderer
extends AbstractVisitor
implements NodeRenderer {
    protected final TextContentNodeRendererContext context;
    private final TextContentWriter textContent;
    private Integer orderedListCounter;
    private Character orderedListDelimiter;
    private Character bulletListMarker;

    public CoreTextContentNodeRenderer(TextContentNodeRendererContext context) {
        this.context = context;
        this.textContent = context.getWriter();
    }

    @Override
    public Set<Class<? extends Node>> getNodeTypes() {
        return new HashSet<Class<? extends Node>>(Arrays.asList(Document.class, Heading.class, Paragraph.class, BlockQuote.class, BulletList.class, FencedCodeBlock.class, HtmlBlock.class, ThematicBreak.class, IndentedCodeBlock.class, Link.class, ListItem.class, OrderedList.class, Image.class, Emphasis.class, StrongEmphasis.class, Text.class, Code.class, HtmlInline.class, SoftLineBreak.class, HardLineBreak.class));
    }

    @Override
    public void render(Node node) {
        node.accept(this);
    }

    @Override
    public void visit(Document document) {
        this.visitChildren(document);
    }

    @Override
    public void visit(BlockQuote blockQuote) {
        this.textContent.write('\u00ab');
        this.visitChildren(blockQuote);
        this.textContent.write('\u00bb');
        this.writeEndOfLine(blockQuote, null);
    }

    @Override
    public void visit(BulletList bulletList) {
        this.bulletListMarker = Character.valueOf(bulletList.getBulletMarker());
        this.visitChildren(bulletList);
        this.writeEndOfLine(bulletList, null);
        this.bulletListMarker = null;
    }

    @Override
    public void visit(Code code) {
        this.textContent.write('\"');
        this.textContent.write(code.getLiteral());
        this.textContent.write('\"');
    }

    @Override
    public void visit(FencedCodeBlock fencedCodeBlock) {
        if (this.context.stripNewlines()) {
            this.textContent.writeStripped(fencedCodeBlock.getLiteral());
            this.writeEndOfLine(fencedCodeBlock, null);
        } else {
            this.textContent.write(fencedCodeBlock.getLiteral());
        }
    }

    @Override
    public void visit(HardLineBreak hardLineBreak) {
        this.writeEndOfLine(hardLineBreak, null);
    }

    @Override
    public void visit(Heading heading) {
        this.visitChildren(heading);
        this.writeEndOfLine(heading, Character.valueOf(':'));
    }

    @Override
    public void visit(ThematicBreak thematicBreak) {
        if (!this.context.stripNewlines()) {
            this.textContent.write("***");
        }
        this.writeEndOfLine(thematicBreak, null);
    }

    @Override
    public void visit(HtmlInline htmlInline) {
        this.writeText(htmlInline.getLiteral());
    }

    @Override
    public void visit(HtmlBlock htmlBlock) {
        this.writeText(htmlBlock.getLiteral());
    }

    @Override
    public void visit(Image image) {
        this.writeLink(image, image.getTitle(), image.getDestination());
    }

    @Override
    public void visit(IndentedCodeBlock indentedCodeBlock) {
        if (this.context.stripNewlines()) {
            this.textContent.writeStripped(indentedCodeBlock.getLiteral());
            this.writeEndOfLine(indentedCodeBlock, null);
        } else {
            this.textContent.write(indentedCodeBlock.getLiteral());
        }
    }

    @Override
    public void visit(Link link) {
        this.writeLink(link, link.getTitle(), link.getDestination());
    }

    @Override
    public void visit(ListItem listItem) {
        if (this.orderedListCounter != null) {
            this.textContent.write(String.valueOf(this.orderedListCounter) + this.orderedListDelimiter + " ");
            this.visitChildren(listItem);
            this.writeEndOfLine(listItem, null);
            Integer n = this.orderedListCounter;
            Integer n2 = this.orderedListCounter = Integer.valueOf(this.orderedListCounter + 1);
        } else if (this.bulletListMarker != null) {
            if (!this.context.stripNewlines()) {
                this.textContent.write(this.bulletListMarker + " ");
            }
            this.visitChildren(listItem);
            this.writeEndOfLine(listItem, null);
        }
    }

    @Override
    public void visit(OrderedList orderedList) {
        this.orderedListCounter = orderedList.getStartNumber();
        this.orderedListDelimiter = Character.valueOf(orderedList.getDelimiter());
        this.visitChildren(orderedList);
        this.writeEndOfLine(orderedList, null);
        this.orderedListCounter = null;
        this.orderedListDelimiter = null;
    }

    @Override
    public void visit(Paragraph paragraph) {
        this.visitChildren(paragraph);
        if (paragraph.getParent() == null || paragraph.getParent() instanceof Document) {
            this.writeEndOfLine(paragraph, null);
        }
    }

    @Override
    public void visit(SoftLineBreak softLineBreak) {
        this.writeEndOfLine(softLineBreak, null);
    }

    @Override
    public void visit(Text text) {
        this.writeText(text.getLiteral());
    }

    @Override
    protected void visitChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.context.render(node);
            node = next;
        }
    }

    private void writeText(String text) {
        if (this.context.stripNewlines()) {
            this.textContent.writeStripped(text);
        } else {
            this.textContent.write(text);
        }
    }

    private void writeLink(Node node, String title, String destination) {
        boolean hasDestination;
        boolean hasChild = node.getFirstChild() != null;
        boolean hasTitle = title != null;
        boolean bl = hasDestination = destination != null && !destination.equals("");
        if (hasChild) {
            this.textContent.write('\"');
            this.visitChildren(node);
            this.textContent.write('\"');
            if (hasTitle || hasDestination) {
                this.textContent.whitespace();
                this.textContent.write('(');
            }
        }
        if (hasTitle) {
            this.textContent.write(title);
            if (hasDestination) {
                this.textContent.colon();
                this.textContent.whitespace();
            }
        }
        if (hasDestination) {
            this.textContent.write(destination);
        }
        if (hasChild && (hasTitle || hasDestination)) {
            this.textContent.write(')');
        }
    }

    private void writeEndOfLine(Node node, Character c) {
        if (this.context.stripNewlines()) {
            if (c != null) {
                this.textContent.write(c.charValue());
            }
            if (node.getNext() != null) {
                this.textContent.whitespace();
            }
        } else if (node.getNext() != null) {
            this.textContent.line();
        }
    }
}

