/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.threetenbp.ser;

import com.fasterxml.jackson.datatype.threetenbp.function.ToIntFunction;
import com.fasterxml.jackson.datatype.threetenbp.function.ToLongFunction;
import com.fasterxml.jackson.datatype.threetenbp.ser.InstantSerializerBase;
import com.fasterxml.jackson.datatype.threetenbp.ser.ThreeTenFormattedSerializerBase;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;

public class ZonedDateTimeWithZoneIdSerializer
extends InstantSerializerBase<ZonedDateTime> {
    private static final long serialVersionUID = 1L;
    public static final ZonedDateTimeWithZoneIdSerializer INSTANCE = new ZonedDateTimeWithZoneIdSerializer();

    protected ZonedDateTimeWithZoneIdSerializer() {
        super(ZonedDateTime.class, new ToLongFunction<ZonedDateTime>(){

            @Override
            public long applyAsLong(ZonedDateTime value) {
                return value.toInstant().toEpochMilli();
            }
        }, new ToLongFunction<ZonedDateTime>(){

            @Override
            public long applyAsLong(ZonedDateTime value) {
                return value.toEpochSecond();
            }
        }, new ToIntFunction<ZonedDateTime>(){

            @Override
            public int applyAsInt(ZonedDateTime value) {
                return value.getNano();
            }
        }, null);
    }

    protected ZonedDateTimeWithZoneIdSerializer(ZonedDateTimeWithZoneIdSerializer base, Boolean useTimestamp, DateTimeFormatter formatter) {
        super(base, useTimestamp, formatter);
    }

    @Override
    protected ThreeTenFormattedSerializerBase<?> withFormat(Boolean useTimestamp, DateTimeFormatter formatter) {
        return new ZonedDateTimeWithZoneIdSerializer(this, useTimestamp, formatter);
    }
}

