/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.validation;

import java.util.function.Function;
import org.openapitools.codegen.validation.Severity;

public class ValidationRule {
    private Severity severity;
    private String description;
    private String failureMessage;
    private Function<Object, Boolean> test;

    ValidationRule(Severity severity, String description, String failureMessage, Function<Object, Boolean> test) {
        this.severity = severity;
        this.description = description;
        this.failureMessage = failureMessage;
        this.test = test;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public boolean evaluate(Object input) {
        return this.test.apply(input);
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getDescription() {
        return this.description;
    }

    static ValidationRule empty() {
        return new ValidationRule(Severity.ERROR, "empty", "failure message", i -> false);
    }

    public static <T> ValidationRule create(Severity severity, String description, String failureMessage, Function<T, Boolean> fn) {
        return new ValidationRule(severity, description, failureMessage, fn);
    }

    public static <T> ValidationRule error(String failureMessage, Function<T, Boolean> fn) {
        return new ValidationRule(Severity.ERROR, null, failureMessage, fn);
    }

    public static <T> ValidationRule warn(String description, String failureMessage, Function<T, Boolean> fn) {
        return new ValidationRule(Severity.WARNING, description, failureMessage, fn);
    }

    public String toString() {
        return "ValidationRule{severity=" + (Object)((Object)this.severity) + ", description='" + this.description + '\'' + ", failureMessage='" + this.failureMessage + '\'' + '}';
    }
}

