/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.zipkin.internal;

import java.time.Duration;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.zipkin.ZipkinSpanExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.internal.StructuredConfigProperties;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export.SpanExporter;

public class ZipkinSpanExporterComponentProvider
implements ComponentProvider<SpanExporter> {
    @Override
    public Class<SpanExporter> getType() {
        return SpanExporter.class;
    }

    @Override
    public String getName() {
        return "zipkin";
    }

    @Override
    public SpanExporter create(StructuredConfigProperties config) {
        Long timeoutMs;
        ZipkinSpanExporterBuilder builder = ZipkinSpanExporter.builder();
        String endpoint = config.getString("endpoint");
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        if ((timeoutMs = config.getLong("timeout")) != null) {
            builder.setReadTimeout(Duration.ofMillis(timeoutMs));
        }
        return builder.build();
    }
}

