/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionConnectionContext;
import org.apache.shardingsphere.transaction.api.TransactionType;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.spi.ShardingSphereDistributedTransactionManager;

public final class ConnectionTransaction {
    private final TransactionType transactionType;
    private final ShardingSphereDistributedTransactionManager distributedTransactionManager;
    private final TransactionConnectionContext transactionContext;

    public ConnectionTransaction(TransactionRule rule, TransactionConnectionContext transactionContext) {
        this.transactionType = transactionContext.getTransactionType().isPresent() ? TransactionType.valueOf((String)((String)transactionContext.getTransactionType().get())) : rule.getDefaultType();
        this.transactionContext = transactionContext;
        this.distributedTransactionManager = TransactionType.LOCAL == this.transactionType ? null : rule.getResource().getTransactionManager(rule.getDefaultType());
    }

    public boolean isInDistributedTransaction(TransactionConnectionContext transactionContext) {
        return transactionContext.isInTransaction() && this.isInDistributedTransaction();
    }

    public boolean isInDistributedTransaction() {
        return null != this.distributedTransactionManager && this.distributedTransactionManager.isInTransaction();
    }

    public boolean isLocalTransaction() {
        return TransactionType.LOCAL == this.transactionType;
    }

    public boolean isHoldTransaction(boolean autoCommit) {
        return TransactionType.LOCAL == this.transactionType && !autoCommit || TransactionType.XA == this.transactionType && this.isInDistributedTransaction();
    }

    public Optional<Connection> getConnection(String databaseName, String dataSourceName, TransactionConnectionContext transactionConnectionContext) throws SQLException {
        return this.isInDistributedTransaction(transactionConnectionContext) ? Optional.of(this.distributedTransactionManager.getConnection(databaseName, dataSourceName)) : Optional.empty();
    }

    public void begin() {
        this.distributedTransactionManager.begin();
    }

    public void commit() {
        this.distributedTransactionManager.commit(this.transactionContext.isExceptionOccur());
    }

    public void rollback() {
        this.distributedTransactionManager.rollback();
    }

    public Optional<DistributedTransactionOperationType> getDistributedTransactionOperationType(boolean autoCommit) {
        if (!autoCommit && !this.distributedTransactionManager.isInTransaction()) {
            return Optional.of(DistributedTransactionOperationType.BEGIN);
        }
        if (autoCommit && this.distributedTransactionManager.isInTransaction()) {
            return Optional.of(DistributedTransactionOperationType.COMMIT);
        }
        return Optional.empty();
    }

    @Generated
    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public static enum DistributedTransactionOperationType {
        BEGIN,
        COMMIT;

    }
}

