/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Properties;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.instance.metadata.jdbc.JDBCInstanceMetaData;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.event.subsciber.EventSubscriberRegistry;
import org.apache.shardingsphere.mode.lock.GlobalLockContext;
import org.apache.shardingsphere.mode.lock.LockPersistService;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilder;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.manager.cluster.event.subscriber.registry.ClusterDeliverEventSubscriberRegistry;
import org.apache.shardingsphere.mode.manager.cluster.event.subscriber.registry.ClusterDispatchEventSubscriberRegistry;
import org.apache.shardingsphere.mode.manager.cluster.exception.MissingRequiredClusterRepositoryConfigurationException;
import org.apache.shardingsphere.mode.manager.cluster.listener.DataChangedEventListenerRegistry;
import org.apache.shardingsphere.mode.manager.cluster.lock.GlobalLockPersistService;
import org.apache.shardingsphere.mode.manager.cluster.workerid.ClusterWorkerIdGenerator;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryConfiguration;
import org.apache.shardingsphere.mode.spi.PersistRepository;

public final class ClusterContextManagerBuilder
implements ContextManagerBuilder {
    public ContextManager build(ContextManagerBuilderParameter param, EventBusContext eventBusContext) throws SQLException {
        ModeConfiguration modeConfig = param.getModeConfiguration();
        ClusterPersistRepositoryConfiguration config = (ClusterPersistRepositoryConfiguration)modeConfig.getRepository();
        ComputeNodeInstanceContext computeNodeInstanceContext = new ComputeNodeInstanceContext(new ComputeNodeInstance(param.getInstanceMetaData(), param.getLabels()), modeConfig, eventBusContext);
        ClusterPersistRepository repository = this.getClusterPersistRepository(config);
        repository.init(config, computeNodeInstanceContext);
        GlobalLockContext lockContext = new GlobalLockContext((LockPersistService)new GlobalLockPersistService(repository));
        computeNodeInstanceContext.init((WorkerIdGenerator)new ClusterWorkerIdGenerator(repository, param.getInstanceMetaData().getId()), (LockContext)lockContext);
        MetaDataPersistService metaDataPersistService = new MetaDataPersistService((PersistRepository)repository);
        MetaDataContexts metaDataContexts = MetaDataContextsFactory.create((MetaDataPersistService)metaDataPersistService, (ContextManagerBuilderParameter)param, (ComputeNodeInstanceContext)computeNodeInstanceContext);
        ContextManager result = new ContextManager(metaDataContexts, computeNodeInstanceContext, (PersistRepository)repository);
        this.registerOnline(computeNodeInstanceContext, param, result);
        return result;
    }

    private ClusterPersistRepository getClusterPersistRepository(ClusterPersistRepositoryConfiguration config) {
        ShardingSpherePreconditions.checkNotNull((Object)config, MissingRequiredClusterRepositoryConfigurationException::new);
        return (ClusterPersistRepository)TypedSPILoader.getService(ClusterPersistRepository.class, (Object)config.getType(), (Properties)config.getProps());
    }

    private void registerOnline(ComputeNodeInstanceContext computeNodeInstanceContext, ContextManagerBuilderParameter param, ContextManager contextManager) {
        contextManager.getPersistServiceFacade().getComputeNodePersistService().registerOnline(computeNodeInstanceContext.getInstance());
        contextManager.getComputeNodeInstanceContext().getAllClusterInstances().addAll(contextManager.getPersistServiceFacade().getComputeNodePersistService().loadAllComputeNodeInstances());
        new DataChangedEventListenerRegistry(contextManager, this.getDatabaseNames(param, contextManager.getPersistServiceFacade().getMetaDataPersistService())).register();
        EventSubscriberRegistry eventSubscriberRegistry = new EventSubscriberRegistry(contextManager.getComputeNodeInstanceContext().getEventBusContext());
        eventSubscriberRegistry.register(new ClusterDeliverEventSubscriberRegistry(contextManager).getSubscribers());
        eventSubscriberRegistry.register(new ClusterDispatchEventSubscriberRegistry(contextManager).getSubscribers());
    }

    private Collection<String> getDatabaseNames(ContextManagerBuilderParameter param, MetaDataPersistService metaDataPersistService) {
        return param.getInstanceMetaData() instanceof JDBCInstanceMetaData ? param.getDatabaseConfigs().keySet() : metaDataPersistService.getDatabaseMetaDataFacade().getDatabase().loadAllDatabaseNames();
    }

    public String getType() {
        return "Cluster";
    }
}

