/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.event.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.state.cluster.ClusterState;
import org.apache.shardingsphere.metadata.persist.node.StatesNode;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.event.dispatch.DispatchEvent;
import org.apache.shardingsphere.mode.event.dispatch.state.cluster.ClusterStateEvent;
import org.apache.shardingsphere.mode.manager.cluster.event.builder.DispatchEventBuilder;

public final class ClusterStateDispatchEventBuilder
implements DispatchEventBuilder<DispatchEvent> {
    @Override
    public String getSubscribedKey() {
        return StatesNode.getClusterStateNodePath();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED);
    }

    @Override
    public Optional<DispatchEvent> build(DataChangedEvent event) {
        return event.getKey().equals(StatesNode.getClusterStateNodePath()) ? Optional.of(new ClusterStateEvent(this.getClusterState(event))) : Optional.empty();
    }

    private ClusterState getClusterState(DataChangedEvent event) {
        try {
            return ClusterState.valueOf((String)event.getValue());
        }
        catch (IllegalArgumentException ignore) {
            return ClusterState.OK;
        }
    }
}

