/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.event.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.metadata.persist.node.GlobalNode;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.event.dispatch.config.AlterPropertiesEvent;
import org.apache.shardingsphere.mode.manager.cluster.event.builder.DispatchEventBuilder;
import org.apache.shardingsphere.mode.path.GlobalNodePath;

public final class PropertiesDispatchEventBuilder
implements DispatchEventBuilder<AlterPropertiesEvent> {
    @Override
    public String getSubscribedKey() {
        return GlobalNode.getPropsRootNode();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED);
    }

    @Override
    public Optional<AlterPropertiesEvent> build(DataChangedEvent event) {
        return GlobalNodePath.isPropsActiveVersionPath((String)event.getKey()) ? Optional.of(new AlterPropertiesEvent(event.getKey(), event.getValue())) : Optional.empty();
    }
}

