/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.event.builder;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDataSource;
import org.apache.shardingsphere.infra.state.datasource.qualified.QualifiedDataSourceState;
import org.apache.shardingsphere.infra.state.datasource.qualified.yaml.YamlQualifiedDataSourceState;
import org.apache.shardingsphere.infra.state.datasource.qualified.yaml.YamlQualifiedDataSourceStateSwapper;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.metadata.persist.node.QualifiedDataSourceNode;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.event.dispatch.DispatchEvent;
import org.apache.shardingsphere.mode.event.dispatch.state.storage.QualifiedDataSourceStateEvent;
import org.apache.shardingsphere.mode.manager.cluster.event.builder.DispatchEventBuilder;

public final class QualifiedDataSourceDispatchEventBuilder
implements DispatchEventBuilder<DispatchEvent> {
    @Override
    public String getSubscribedKey() {
        return QualifiedDataSourceNode.getRootPath();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED);
    }

    @Override
    public Optional<DispatchEvent> build(DataChangedEvent event) {
        if (Strings.isNullOrEmpty((String)event.getValue())) {
            return Optional.empty();
        }
        Optional qualifiedDataSource = QualifiedDataSourceNode.extractQualifiedDataSource((String)event.getKey());
        if (qualifiedDataSource.isPresent()) {
            QualifiedDataSourceState state = new YamlQualifiedDataSourceStateSwapper().swapToObject((YamlQualifiedDataSourceState)YamlEngine.unmarshal((String)event.getValue(), YamlQualifiedDataSourceState.class));
            return Optional.of(new QualifiedDataSourceStateEvent((QualifiedDataSource)qualifiedDataSource.get(), state));
        }
        return Optional.empty();
    }
}

