/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.event.subscriber.dispatch;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.infra.util.eventbus.EventSubscriber;
import org.apache.shardingsphere.mode.event.dispatch.metadata.schema.SchemaAddedEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.schema.SchemaDeletedEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.schema.table.CreateOrAlterTableEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.schema.table.DropTableEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.schema.view.CreateOrAlterViewEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.schema.view.DropViewEvent;
import org.apache.shardingsphere.mode.lock.GlobalLockContext;
import org.apache.shardingsphere.mode.lock.LockPersistService;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.lock.GlobalLockPersistService;
import org.apache.shardingsphere.mode.metadata.refresher.ShardingSphereStatisticsRefreshEngine;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class MetaDataChangedSubscriber
implements EventSubscriber {
    private final ContextManager contextManager;
    private final ClusterPersistRepository repository;

    public MetaDataChangedSubscriber(ContextManager contextManager) {
        this.contextManager = contextManager;
        this.repository = (ClusterPersistRepository)contextManager.getPersistServiceFacade().getRepository();
    }

    @Subscribe
    public synchronized void renew(SchemaAddedEvent event) {
        this.contextManager.getMetaDataContextManager().getSchemaMetaDataManager().addSchema(event.getDatabaseName(), event.getSchemaName());
        this.refreshShardingSphereStatisticsData();
    }

    @Subscribe
    public synchronized void renew(SchemaDeletedEvent event) {
        this.contextManager.getMetaDataContextManager().getSchemaMetaDataManager().dropSchema(event.getDatabaseName(), event.getSchemaName());
        this.refreshShardingSphereStatisticsData();
    }

    @Subscribe
    public synchronized void renew(CreateOrAlterTableEvent event) {
        Preconditions.checkArgument((boolean)event.getActiveVersion().equals(this.contextManager.getPersistServiceFacade().getMetaDataPersistService().getMetaDataVersionPersistService().getActiveVersionByFullPath(event.getActiveVersionKey())), (String)"Invalid active version: %s of key: %s", (Object)event.getActiveVersion(), (Object)event.getActiveVersionKey());
        ShardingSphereTable table = this.contextManager.getPersistServiceFacade().getMetaDataPersistService().getDatabaseMetaDataFacade().getTable().load(event.getDatabaseName(), event.getSchemaName(), event.getTableName());
        this.contextManager.getMetaDataContextManager().getSchemaMetaDataManager().alterSchema(event.getDatabaseName(), event.getSchemaName(), table, null);
        this.refreshShardingSphereStatisticsData();
    }

    @Subscribe
    public synchronized void renew(DropTableEvent event) {
        this.contextManager.getMetaDataContextManager().getSchemaMetaDataManager().alterSchema(event.getDatabaseName(), event.getSchemaName(), event.getTableName(), null);
        this.refreshShardingSphereStatisticsData();
    }

    @Subscribe
    public synchronized void renew(CreateOrAlterViewEvent event) {
        Preconditions.checkArgument((boolean)event.getActiveVersion().equals(this.contextManager.getPersistServiceFacade().getMetaDataPersistService().getMetaDataVersionPersistService().getActiveVersionByFullPath(event.getActiveVersionKey())), (String)"Invalid active version: %s of key: %s", (Object)event.getActiveVersion(), (Object)event.getActiveVersionKey());
        ShardingSphereView view = this.contextManager.getPersistServiceFacade().getMetaDataPersistService().getDatabaseMetaDataFacade().getView().load(event.getDatabaseName(), event.getSchemaName(), event.getViewName());
        this.contextManager.getMetaDataContextManager().getSchemaMetaDataManager().alterSchema(event.getDatabaseName(), event.getSchemaName(), null, view);
        this.refreshShardingSphereStatisticsData();
    }

    @Subscribe
    public synchronized void renew(DropViewEvent event) {
        this.contextManager.getMetaDataContextManager().getSchemaMetaDataManager().alterSchema(event.getDatabaseName(), event.getSchemaName(), null, event.getViewName());
        this.refreshShardingSphereStatisticsData();
    }

    private void refreshShardingSphereStatisticsData() {
        if (this.contextManager.getComputeNodeInstanceContext().getModeConfiguration().isCluster() && InstanceType.PROXY == this.contextManager.getComputeNodeInstanceContext().getInstance().getMetaData().getType()) {
            new ShardingSphereStatisticsRefreshEngine(this.contextManager, new GlobalLockContext((LockPersistService)new GlobalLockPersistService(this.repository))).asyncRefresh();
        }
    }
}

