/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dal.show;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryMergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;

public class LogicTablesMergedResult
extends MemoryMergedResult<ShardingRule> {
    public LogicTablesMergedResult(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, ShardingSphereSchema schema, List<QueryResult> queryResults) throws SQLException {
        super((ShardingSphereRule)shardingRule, schema, sqlStatementContext, queryResults);
    }

    protected final List<MemoryQueryResultRow> init(ShardingRule shardingRule, ShardingSphereSchema schema, SQLStatementContext sqlStatementContext, List<QueryResult> queryResults) throws SQLException {
        LinkedList<MemoryQueryResultRow> result = new LinkedList<MemoryQueryResultRow>();
        HashSet<String> tableNames = new HashSet<String>();
        for (QueryResult each : queryResults) {
            while (each.next()) {
                this.createMemoryQueryResultRow(shardingRule, schema, each, tableNames).ifPresent(result::add);
            }
        }
        return result;
    }

    private Optional<MemoryQueryResultRow> createMemoryQueryResultRow(ShardingRule shardingRule, ShardingSphereSchema schema, QueryResult queryResult, Set<String> tableNames) throws SQLException {
        MemoryQueryResultRow memoryResultSetRow = new MemoryQueryResultRow(queryResult);
        String actualTableName = memoryResultSetRow.getCell(1).toString();
        Optional<ShardingTable> shardingTable = shardingRule.findShardingTableByActualTable(actualTableName);
        if (shardingTable.isPresent() && tableNames.add(shardingTable.get().getLogicTable())) {
            String logicTableName = shardingTable.get().getLogicTable();
            memoryResultSetRow.setCell(1, (Object)logicTableName);
            this.setCellValue(memoryResultSetRow, logicTableName, actualTableName, schema.getTable(logicTableName), shardingRule);
            return Optional.of(memoryResultSetRow);
        }
        if (shardingRule.getShardingTables().isEmpty() || tableNames.add(actualTableName)) {
            this.setCellValue(memoryResultSetRow, actualTableName, actualTableName, schema.getTable(actualTableName), shardingRule);
            return Optional.of(memoryResultSetRow);
        }
        return Optional.empty();
    }

    protected void setCellValue(MemoryQueryResultRow memoryResultSetRow, String logicTableName, String actualTableName, ShardingSphereTable table, ShardingRule shardingRule) {
    }
}

