/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.IndexAvailable;
import org.apache.shardingsphere.infra.database.core.metadata.database.object.DialectObjectUniquenessLevelProvider;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.IndexToken;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;

public final class ShardingIndexTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext>,
SchemaMetaDataAware {
    private final ShardingRule shardingRule;
    private Map<String, ShardingSphereSchema> schemas;
    private ShardingSphereSchema defaultSchema;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof IndexAvailable && !((IndexAvailable)sqlStatementContext).getIndexes().isEmpty() && this.isSchemaUniquenessLevelIndex(sqlStatementContext.getDatabaseType());
    }

    private boolean isSchemaUniquenessLevelIndex(DatabaseType databaseType) {
        return TypedSPILoader.findService(DialectObjectUniquenessLevelProvider.class, (Object)databaseType).map(optional -> DialectObjectUniquenessLevelProvider.UniquenessLevel.SCHEMA_LEVEL == optional.getIndexUniquenessLevel()).orElse(false);
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        if (sqlStatementContext instanceof IndexAvailable) {
            for (IndexSegment each : ((IndexAvailable)sqlStatementContext).getIndexes()) {
                ShardingSphereSchema schema = each.getOwner().isPresent() ? this.schemas.get(((OwnerSegment)each.getOwner().get()).getIdentifier().getValue()) : this.defaultSchema;
                result.add(new IndexToken(each.getIndexName().getStartIndex(), each.getStopIndex(), each.getIndexName().getIdentifier(), sqlStatementContext, this.shardingRule, schema));
            }
        }
        return result;
    }

    @Generated
    public ShardingIndexTokenGenerator(ShardingRule shardingRule) {
        this.shardingRule = shardingRule;
    }

    @Generated
    public void setSchemas(Map<String, ShardingSphereSchema> schemas) {
        this.schemas = schemas;
    }

    @Generated
    public void setDefaultSchema(ShardingSphereSchema defaultSchema) {
        this.defaultSchema = defaultSchema;
    }
}

