/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.pojo;

import com.google.common.base.Strings;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.RouteUnitAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.Substitutable;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.TokenUtils;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class CursorToken
extends SQLToken
implements Substitutable,
RouteUnitAware {
    private final int stopIndex;
    private final IdentifierValue identifier;
    private final SQLStatementContext sqlStatementContext;
    private final ShardingRule shardingRule;

    public CursorToken(int startIndex, int stopIndex, IdentifierValue identifier, SQLStatementContext sqlStatementContext, ShardingRule shardingRule) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.identifier = identifier;
        this.sqlStatementContext = sqlStatementContext;
        this.shardingRule = shardingRule;
    }

    public String toString(RouteUnit routeUnit) {
        return this.identifier.getQuoteCharacter().wrap(this.getCursorValue(routeUnit));
    }

    private String getCursorValue(RouteUnit routeUnit) {
        Map<String, String> logicAndActualTables = TokenUtils.getLogicAndActualTableMap(routeUnit, this.sqlStatementContext, this.shardingRule);
        String actualTableName = logicAndActualTables.values().stream().sorted().findFirst().orElse(null);
        return Strings.isNullOrEmpty((String)actualTableName) ? this.identifier.getValue() : this.identifier.getValue() + "_" + actualTableName;
    }

    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }
}

