/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.operator.physical;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.util.SqlString;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.schema.SQLFederationTable;
import org.apache.shardingsphere.sqlfederation.optimizer.sql.SQLDialectFactory;

public final class EnumerableScan
extends TableScan
implements EnumerableRel {
    private final SqlString sqlString;
    private final RelDataType pushDownRowType;

    public EnumerableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, RelNode pushDownRelNode, String databaseType) {
        super(cluster, traitSet, Collections.emptyList(), table);
        this.traitSet = this.traitSet.replace((RelTrait)EnumerableConvention.INSTANCE);
        this.sqlString = this.createSQLString(pushDownRelNode, databaseType);
        this.pushDownRowType = pushDownRelNode.getRowType();
    }

    public EnumerableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, SqlString sqlString, RelDataType pushDownRowType) {
        super(cluster, traitSet, Collections.emptyList(), table);
        this.traitSet = this.traitSet.replace((RelTrait)EnumerableConvention.INSTANCE);
        this.sqlString = sqlString;
        this.pushDownRowType = pushDownRowType;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableScan(this.getCluster(), traitSet, this.table, this.sqlString, this.pushDownRowType);
    }

    public RelWriter explainTerms(RelWriter relWriter) {
        return super.explainTerms(relWriter).item("sql", (Object)this.sqlString.getSql().replaceAll(System.lineSeparator(), " ")).item("dynamicParameters", (Object)this.sqlString.getDynamicParameters());
    }

    public RelDataType deriveRowType() {
        return this.pushDownRowType;
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getPushDownRowType(), (JavaRowFormat)pref.preferArray());
        int[] paramIndexes = null == this.sqlString.getDynamicParameters() ? new int[]{} : this.getParamIndexes((Collection<Integer>)this.sqlString.getDynamicParameters());
        return implementor.result(physType, Blocks.toBlock((Node)Expressions.call((Expression)Objects.requireNonNull(this.table.getExpression(SQLFederationTable.class)), (String)"execute", (Expression[])new Expression[]{implementor.getRootExpression(), Expressions.constant((Object)this.sqlString.getSql().replace("u&'\\", "'\\u")), Expressions.constant((Object)paramIndexes)})));
    }

    private SqlString createSQLString(RelNode scanContext, String databaseType) {
        SqlDialect sqlDialect = SQLDialectFactory.getSQLDialect(databaseType);
        return new RelToSqlConverter(sqlDialect).visitRoot(scanContext).asStatement().toSqlString(sqlDialect);
    }

    private int[] getParamIndexes(Collection<Integer> dynamicParameters) {
        int[] result = new int[dynamicParameters.size()];
        int index = 0;
        for (Integer each : dynamicParameters) {
            result[index++] = each;
        }
        return result;
    }

    @Generated
    public SqlString getSqlString() {
        return this.sqlString;
    }

    @Generated
    public RelDataType getPushDownRowType() {
        return this.pushDownRowType;
    }
}

