/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.reviser;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.data.model.SchemaMetaData;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.schema.SchemaMetaDataReviseEngine;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class MetaDataReviseEngine {
    private final Collection<ShardingSphereRule> rules;

    public Map<String, SchemaMetaData> revise(Map<String, SchemaMetaData> schemaMetaDataMap, GenericSchemaBuilderMaterial material) {
        LinkedHashMap<String, SchemaMetaData> result = new LinkedHashMap<String, SchemaMetaData>(schemaMetaDataMap.size(), 1.0f);
        for (Map.Entry<String, SchemaMetaData> entry : schemaMetaDataMap.entrySet()) {
            DatabaseType databaseType = material.getStorageTypes().values().stream().findFirst().orElse(null);
            DataSource dataSource = material.getDataSourceMap().values().stream().findFirst().orElse(null);
            result.put(entry.getKey(), new SchemaMetaDataReviseEngine(this.rules, material.getProps(), databaseType, dataSource).revise(entry.getValue()));
        }
        return result;
    }

    @Generated
    public MetaDataReviseEngine(Collection<ShardingSphereRule> rules) {
        this.rules = rules;
    }
}

