/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.statistics.collector.tables;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereRowData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.statistics.collector.ShardingSphereStatisticsCollector;
import org.apache.shardingsphere.infra.metadata.statistics.collector.ShardingSphereTableDataCollectorUtils;

public final class PgNamespaceTableCollector
implements ShardingSphereStatisticsCollector {
    private static final String PG_NAMESPACE = "pg_namespace";
    private static final String PUBLIC_SCHEMA = "public";
    private static final Long PUBLIC_SCHEMA_OID = 0L;

    @Override
    public Optional<ShardingSphereTableData> collect(String databaseName, ShardingSphereTable table, Map<String, ShardingSphereDatabase> databases, RuleMetaData globalRuleMetaData) throws SQLException {
        ShardingSphereTableData result = new ShardingSphereTableData(PG_NAMESPACE);
        long oid = 1L;
        for (Map.Entry<String, ShardingSphereSchema> entry : databases.get(databaseName).getSchemas().entrySet()) {
            long l;
            Collection<ShardingSphereRowData> collection = result.getRows();
            if (PUBLIC_SCHEMA.equalsIgnoreCase(entry.getKey())) {
                l = PUBLIC_SCHEMA_OID;
            } else {
                long l2 = oid;
                l = l2;
                oid = l2 + 1L;
            }
            collection.add(new ShardingSphereRowData(this.getRow(l, entry.getKey(), table)));
        }
        return Optional.of(result);
    }

    private List<Object> getRow(Long oid, String schemaName, ShardingSphereTable table) {
        CaseInsensitiveMap columnValues = new CaseInsensitiveMap(2, 1.0f);
        columnValues.put("oid", oid);
        columnValues.put("nspname", schemaName);
        return ShardingSphereTableDataCollectorUtils.createRowValue((Map<String, Object>)columnValues, table);
    }

    public String getType() {
        return PG_NAMESPACE;
    }
}

