/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.checker;

import java.util.Collection;
import java.util.Map;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.checker.SupportedSQLCheckersBuilder;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;

public final class SupportedSQLCheckEngine {
    public void checkSQL(Collection<ShardingSphereRule> rules, SQLStatementContext sqlStatementContext, Map<String, ShardingSphereSchema> schemas, String databaseName) {
        ShardingSphereSchema schema = this.getSchema(sqlStatementContext, schemas, databaseName);
        for (Map.Entry entry : OrderedSPILoader.getServices(SupportedSQLCheckersBuilder.class, rules).entrySet()) {
            Collection checkers = ((SupportedSQLCheckersBuilder)entry.getValue()).getSupportedSQLCheckers();
            for (SupportedSQLChecker<?, SQLStatementContext> supportedSQLChecker : checkers) {
                if (!supportedSQLChecker.isCheck(sqlStatementContext)) continue;
                supportedSQLChecker.check((SQLStatementContext)((ShardingSphereRule)entry.getKey()), schema, sqlStatementContext);
            }
        }
    }

    private ShardingSphereSchema getSchema(SQLStatementContext sqlStatementContext, Map<String, ShardingSphereSchema> schemas, String databaseName) {
        ShardingSphereSchema defaultSchema = schemas.get(new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(databaseName));
        return sqlStatementContext instanceof TableAvailable ? ((TableAvailable)sqlStatementContext).getTablesContext().getSchemaName().map(schemas::get).orElse(defaultSchema) : defaultSchema;
    }
}

