/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.dml;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.shadow.condition.ShadowColumnCondition;
import org.apache.shardingsphere.shadow.route.engine.dml.AbstractShadowDMLStatementRouteEngine;
import org.apache.shardingsphere.shadow.route.engine.util.ShadowExtractor;
import org.apache.shardingsphere.shadow.spi.ShadowOperationType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.util.ColumnExtractUtils;
import org.apache.shardingsphere.sql.parser.statement.core.util.ExpressionExtractUtils;

public final class ShadowSelectStatementRoutingEngine
extends AbstractShadowDMLStatementRouteEngine {
    private final SelectStatementContext sqlStatementContext;
    private final List<Object> parameters;

    public ShadowSelectStatementRoutingEngine(SelectStatementContext sqlStatementContext, List<Object> parameters, HintValueContext hintValueContext) {
        super((SQLStatementContext)sqlStatementContext, hintValueContext, ShadowOperationType.SELECT);
        this.sqlStatementContext = sqlStatementContext;
        this.parameters = parameters;
    }

    @Override
    protected Collection<ShadowColumnCondition> getShadowColumnConditions(String shadowColumnName) {
        LinkedList<ShadowColumnCondition> result = new LinkedList<ShadowColumnCondition>();
        for (ExpressionSegment each : this.getWhereSegment()) {
            Collection columns = ColumnExtractUtils.extract((ExpressionSegment)each);
            if (1 != columns.size()) continue;
            ShadowExtractor.extractValues(each, this.parameters).map(values -> new ShadowColumnCondition(this.extractOwnerName((ColumnSegment)columns.iterator().next()), shadowColumnName, (Collection<Comparable<?>>)values)).ifPresent(result::add);
        }
        return result;
    }

    private Collection<ExpressionSegment> getWhereSegment() {
        LinkedList<ExpressionSegment> result = new LinkedList<ExpressionSegment>();
        for (WhereSegment each : this.sqlStatementContext.getWhereSegments()) {
            for (AndPredicate predicate : ExpressionExtractUtils.getAndPredicates((ExpressionSegment)each.getExpr())) {
                result.addAll(predicate.getPredicates());
            }
        }
        return result;
    }

    private String extractOwnerName(ColumnSegment columnSegment) {
        Optional owner = columnSegment.getOwner();
        return owner.isPresent() ? this.getTableAliasNameMappings().get(((OwnerSegment)owner.get()).getIdentifier().getValue()) : this.getTableAliasNameMappings().keySet().iterator().next();
    }
}

