/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.route.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.table.TableExistsException;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.rule.attribute.datanode.MutableDataNodeRuleAttribute;
import org.apache.shardingsphere.single.exception.SingleTableNotFoundException;
import org.apache.shardingsphere.single.route.engine.SingleRouteEngine;
import org.apache.shardingsphere.single.rule.SingleRule;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;

public final class SingleStandardRouteEngine
implements SingleRouteEngine {
    private final Collection<QualifiedTable> singleTables;
    private final SQLStatement sqlStatement;
    private final HintValueContext hintValueContext;

    @Override
    public void route(RouteContext routeContext, SingleRule singleRule) {
        if (routeContext.getRouteUnits().isEmpty() || this.sqlStatement instanceof SelectStatement) {
            this.routeStatement(routeContext, singleRule);
        } else {
            RouteContext newRouteContext = new RouteContext();
            this.routeStatement(newRouteContext, singleRule);
            this.combineRouteContext(routeContext, newRouteContext);
        }
    }

    private void routeStatement(RouteContext routeContext, SingleRule rule) {
        if (this.sqlStatement instanceof DDLStatement) {
            this.routeDDLStatement(routeContext, rule);
        } else {
            boolean allTablesInSameComputeNode = rule.isAllTablesInSameComputeNode(this.getDataNodes(routeContext), this.singleTables);
            ShardingSpherePreconditions.checkState((boolean)allTablesInSameComputeNode, () -> new UnsupportedSQLOperationException("all tables must be in the same compute node"));
            this.fillRouteContext(rule, routeContext, this.singleTables);
        }
    }

    private Collection<DataNode> getDataNodes(RouteContext routeContext) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (Collection each : routeContext.getOriginalDataNodes()) {
            result.addAll(each);
        }
        return result;
    }

    private void routeDDLStatement(RouteContext routeContext, SingleRule rule) {
        if (this.sqlStatement instanceof CreateTableStatement) {
            QualifiedTable table = this.singleTables.iterator().next();
            Optional dataNode = ((MutableDataNodeRuleAttribute)rule.getAttributes().getAttribute(MutableDataNodeRuleAttribute.class)).findTableDataNode(table.getSchemaName(), table.getTableName());
            boolean containsIfNotExists = ((CreateTableStatement)this.sqlStatement).isIfNotExists();
            if (dataNode.isPresent()) {
                this.routeDDLStatementWithExistTable(routeContext, containsIfNotExists, (DataNode)dataNode.get(), table);
            } else {
                String dataSourceName = rule.assignNewDataSourceName();
                routeContext.getRouteUnits().add(new RouteUnit(new RouteMapper(dataSourceName, dataSourceName), Collections.singleton(new RouteMapper(table.getTableName(), table.getTableName()))));
            }
        } else {
            this.fillRouteContext(rule, routeContext, this.singleTables);
        }
    }

    private void routeDDLStatementWithExistTable(RouteContext routeContext, boolean containsIfNotExists, DataNode dataNode, QualifiedTable table) {
        if (!containsIfNotExists && !this.hintValueContext.isSkipMetadataValidate()) {
            throw new TableExistsException(table.getTableName());
        }
        String dataSourceName = dataNode.getDataSourceName();
        routeContext.getRouteUnits().add(new RouteUnit(new RouteMapper(dataSourceName, dataSourceName), Collections.singleton(new RouteMapper(table.getTableName(), table.getTableName()))));
    }

    private void fillRouteContext(SingleRule singleRule, RouteContext routeContext, Collection<QualifiedTable> logicTables) {
        for (QualifiedTable each : logicTables) {
            String tableName = each.getTableName();
            DataNode dataNode = (DataNode)((MutableDataNodeRuleAttribute)singleRule.getAttributes().getAttribute(MutableDataNodeRuleAttribute.class)).findTableDataNode(each.getSchemaName(), tableName).orElseThrow(() -> new SingleTableNotFoundException(tableName));
            String dataSource = dataNode.getDataSourceName();
            routeContext.putRouteUnit(new RouteMapper(dataSource, dataSource), Collections.singletonList(new RouteMapper(tableName, tableName)));
        }
    }

    private void combineRouteContext(RouteContext routeContext, RouteContext newRouteContext) {
        Map<String, RouteUnit> dataSourceRouteUnits = this.getDataSourceRouteUnits(newRouteContext);
        routeContext.getRouteUnits().removeIf(each -> !dataSourceRouteUnits.containsKey(each.getDataSourceMapper().getLogicName()));
        for (Map.Entry<String, RouteUnit> entry : dataSourceRouteUnits.entrySet()) {
            routeContext.putRouteUnit(entry.getValue().getDataSourceMapper(), entry.getValue().getTableMappers());
        }
    }

    private Map<String, RouteUnit> getDataSourceRouteUnits(RouteContext newRouteContext) {
        return newRouteContext.getRouteUnits().stream().collect(Collectors.toMap(each -> each.getDataSourceMapper().getLogicName(), Function.identity()));
    }

    @Generated
    public SingleStandardRouteEngine(Collection<QualifiedTable> singleTables, SQLStatement sqlStatement, HintValueContext hintValueContext) {
        this.singleTables = singleTables;
        this.sqlStatement = sqlStatement;
        this.hintValueContext = hintValueContext;
    }
}

