/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.util;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.table.TableMapperRuleAttribute;

public final class SingleTableLoadUtils {
    private static final String DELIMITER = ",";

    public static Collection<String> getExcludedTables(Collection<ShardingSphereRule> builtRules) {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (ShardingSphereRule each : builtRules) {
            Optional ruleAttribute = each.getAttributes().findAttribute(TableMapperRuleAttribute.class);
            if (!ruleAttribute.isPresent()) continue;
            result.addAll(((TableMapperRuleAttribute)ruleAttribute.get()).getDistributedTableNames());
            result.addAll(((TableMapperRuleAttribute)ruleAttribute.get()).getActualTableNames());
        }
        return result;
    }

    public static Collection<String> getFeatureRequiredSingleTables(Collection<ShardingSphereRule> builtRules) {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (ShardingSphereRule each : builtRules) {
            Optional ruleAttribute = each.getAttributes().findAttribute(TableMapperRuleAttribute.class);
            if (!ruleAttribute.isPresent() || ((TableMapperRuleAttribute)ruleAttribute.get()).getEnhancedTableNames().isEmpty() || !((TableMapperRuleAttribute)ruleAttribute.get()).getDistributedTableNames().isEmpty()) continue;
            result.addAll(((TableMapperRuleAttribute)ruleAttribute.get()).getEnhancedTableNames());
        }
        return result;
    }

    public static Collection<String> splitTableLines(Collection<String> tables) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String each : tables) {
            if (each.contains(DELIMITER)) {
                result.addAll(Splitter.on((String)DELIMITER).omitEmptyStrings().splitToList((CharSequence)each));
                continue;
            }
            result.add(each);
        }
        return result;
    }

    public static Collection<DataNode> convertToDataNodes(String databaseName, DatabaseType databaseType, Collection<String> tables) {
        LinkedHashSet<DataNode> result = new LinkedHashSet<DataNode>(tables.size(), 1.0f);
        for (String each : tables) {
            result.add(new DataNode(databaseName, databaseType, each));
        }
        return result;
    }

    public static String getAllTablesNodeStr(DatabaseType databaseType) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        return dialectDatabaseMetaData.getDefaultSchema().isPresent() ? "*.*.*" : "*.*";
    }

    public static String getAllTablesNodeStrFromDataSource(DatabaseType databaseType, String dataSourceName, String schemaName) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        return dialectDatabaseMetaData.getDefaultSchema().isPresent() ? SingleTableLoadUtils.formatDataNode(dataSourceName, schemaName, "*") : SingleTableLoadUtils.formatDataNode(dataSourceName, "*");
    }

    public static String getDataNodeString(DatabaseType databaseType, String dataSourceName, String schemaName, String tableName) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        return dialectDatabaseMetaData.getDefaultSchema().isPresent() ? SingleTableLoadUtils.formatDataNode(dataSourceName, schemaName, tableName) : SingleTableLoadUtils.formatDataNode(dataSourceName, tableName);
    }

    private static String formatDataNode(String dataSourceName, String tableName) {
        return String.format("%s.%s", dataSourceName, tableName);
    }

    private static String formatDataNode(String dataSourceName, String schemaName, String tableName) {
        return String.format("%s.%s.%s", dataSourceName, schemaName, tableName);
    }

    @Generated
    private SingleTableLoadUtils() {
    }
}

