/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.rule.attribute;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDataSource;
import org.apache.shardingsphere.infra.rule.attribute.datasource.StaticDataSourceRuleAttribute;
import org.apache.shardingsphere.infra.state.datasource.DataSourceState;
import org.apache.shardingsphere.mode.event.deliver.datasource.qualified.QualifiedDataSourceDeletedEvent;
import org.apache.shardingsphere.readwritesplitting.exception.logic.ReadwriteSplittingDataSourceRuleNotFoundException;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingDataSourceGroupRule;

public final class ReadwriteSplittingStaticDataSourceRuleAttribute
implements StaticDataSourceRuleAttribute {
    private final String databaseName;
    private final Map<String, ReadwriteSplittingDataSourceGroupRule> dataSourceGroupRules;
    private final ComputeNodeInstanceContext computeNodeInstanceContext;

    public Map<String, Collection<String>> getDataSourceMapper() {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>(this.dataSourceGroupRules.size(), 1.0f);
        for (Map.Entry<String, ReadwriteSplittingDataSourceGroupRule> entry : this.dataSourceGroupRules.entrySet()) {
            result.put(entry.getValue().getName(), entry.getValue().getReadwriteSplittingGroup().getAllDataSources());
        }
        return result;
    }

    public void updateStatus(QualifiedDataSource qualifiedDataSource, DataSourceState status) {
        ReadwriteSplittingDataSourceGroupRule dataSourceGroupRule = this.dataSourceGroupRules.get(qualifiedDataSource.getGroupName());
        ShardingSpherePreconditions.checkNotNull((Object)dataSourceGroupRule, () -> new ReadwriteSplittingDataSourceRuleNotFoundException(qualifiedDataSource.getGroupName(), qualifiedDataSource.getDatabaseName()));
        if (DataSourceState.DISABLED == status) {
            dataSourceGroupRule.disableDataSource(qualifiedDataSource.getDataSourceName());
        } else {
            dataSourceGroupRule.enableDataSource(qualifiedDataSource.getDataSourceName());
        }
    }

    public void cleanStorageNodeDataSource(String groupName) {
        ShardingSpherePreconditions.checkContainsKey(this.dataSourceGroupRules, (Object)groupName, () -> new ReadwriteSplittingDataSourceRuleNotFoundException(groupName, this.databaseName));
        this.deleteStorageNodeDataSources(this.dataSourceGroupRules.get(groupName));
    }

    private void deleteStorageNodeDataSources(ReadwriteSplittingDataSourceGroupRule rule) {
        rule.getReadwriteSplittingGroup().getReadDataSources().forEach(each -> this.computeNodeInstanceContext.getEventBusContext().post((Object)new QualifiedDataSourceDeletedEvent(new QualifiedDataSource(this.databaseName, rule.getName(), each))));
    }

    public void cleanStorageNodeDataSources() {
        for (Map.Entry<String, ReadwriteSplittingDataSourceGroupRule> entry : this.dataSourceGroupRules.entrySet()) {
            this.deleteStorageNodeDataSources(entry.getValue());
        }
    }

    @Generated
    public ReadwriteSplittingStaticDataSourceRuleAttribute(String databaseName, Map<String, ReadwriteSplittingDataSourceGroupRule> dataSourceGroupRules, ComputeNodeInstanceContext computeNodeInstanceContext) {
        this.databaseName = databaseName;
        this.dataSourceGroupRules = dataSourceGroupRules;
        this.computeNodeInstanceContext = computeNodeInstanceContext;
    }
}

