/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.rule.changed;

import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.event.dispatch.rule.alter.AlterNamedRuleItemEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.alter.AlterRuleItemEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.drop.DropNamedRuleItemEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.drop.DropRuleItemEvent;
import org.apache.shardingsphere.mode.spi.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.readwritesplitting.config.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.config.rule.ReadwriteSplittingDataSourceGroupRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingRule;
import org.apache.shardingsphere.readwritesplitting.transaction.TransactionalReadQueryStrategy;
import org.apache.shardingsphere.readwritesplitting.yaml.config.rule.YamlReadwriteSplittingDataSourceGroupRuleConfiguration;

public final class ReadwriteSplittingDataSourceChangedProcessor
implements RuleItemConfigurationChangedProcessor<ReadwriteSplittingRuleConfiguration, ReadwriteSplittingDataSourceGroupRuleConfiguration> {
    public ReadwriteSplittingDataSourceGroupRuleConfiguration swapRuleItemConfiguration(AlterRuleItemEvent event, String yamlContent) {
        YamlReadwriteSplittingDataSourceGroupRuleConfiguration yamlDataSourceGroupRuleConfig = (YamlReadwriteSplittingDataSourceGroupRuleConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlReadwriteSplittingDataSourceGroupRuleConfiguration.class);
        return new ReadwriteSplittingDataSourceGroupRuleConfiguration(((AlterNamedRuleItemEvent)event).getItemName(), yamlDataSourceGroupRuleConfig.getWriteDataSourceName(), yamlDataSourceGroupRuleConfig.getReadDataSourceNames(), this.getTransactionalReadQueryStrategy(yamlDataSourceGroupRuleConfig), yamlDataSourceGroupRuleConfig.getLoadBalancerName());
    }

    private TransactionalReadQueryStrategy getTransactionalReadQueryStrategy(YamlReadwriteSplittingDataSourceGroupRuleConfiguration yamlDataSourceGroupRuleConfig) {
        return Strings.isNullOrEmpty((String)yamlDataSourceGroupRuleConfig.getTransactionalReadQueryStrategy()) ? TransactionalReadQueryStrategy.DYNAMIC : TransactionalReadQueryStrategy.valueOf((String)yamlDataSourceGroupRuleConfig.getTransactionalReadQueryStrategy());
    }

    public ReadwriteSplittingRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        Optional rule = database.getRuleMetaData().findSingleRule(ReadwriteSplittingRule.class);
        return rule.map(ReadwriteSplittingRule::getConfiguration).orElseGet(() -> new ReadwriteSplittingRuleConfiguration(new LinkedList(), new LinkedHashMap()));
    }

    public void changeRuleItemConfiguration(AlterRuleItemEvent event, ReadwriteSplittingRuleConfiguration currentRuleConfig, ReadwriteSplittingDataSourceGroupRuleConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getDataSourceGroups().removeIf(each -> each.getName().equals(toBeChangedItemConfig.getName()));
        currentRuleConfig.getDataSourceGroups().add(toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(DropRuleItemEvent event, ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getDataSourceGroups().removeIf(each -> each.getName().equals(((DropNamedRuleItemEvent)event).getItemName()));
    }

    public String getType() {
        return "readwrite_splitting.data_source_groups";
    }
}

