/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.reviser;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.data.model.ColumnMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.data.model.ConstraintMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.data.model.IndexMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.data.model.SchemaMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.data.model.TableMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereConstraint;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereIndex;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.schema.SchemaMetaDataReviseEngine;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class MetaDataReviseEngine {
    private final Collection<ShardingSphereRule> rules;

    public Map<String, ShardingSphereSchema> revise(Map<String, SchemaMetaData> schemaMetaDataMap, GenericSchemaBuilderMaterial material) {
        if (schemaMetaDataMap.isEmpty()) {
            return Collections.singletonMap(material.getDefaultSchemaName(), new ShardingSphereSchema(material.getDefaultSchemaName()));
        }
        HashMap<String, ShardingSphereSchema> result = new HashMap<String, ShardingSphereSchema>(schemaMetaDataMap.size(), 1.0f);
        for (Map.Entry<String, SchemaMetaData> entry : schemaMetaDataMap.entrySet()) {
            SchemaMetaData schemaMetaData = new SchemaMetaDataReviseEngine(this.rules, material.getProps()).revise(entry.getValue());
            result.put(entry.getKey(), new ShardingSphereSchema(entry.getKey(), this.convertToTables(schemaMetaData.getTables()), new LinkedList<ShardingSphereView>()));
        }
        return result;
    }

    private Collection<ShardingSphereTable> convertToTables(Collection<TableMetaData> tableMetaDataList) {
        return tableMetaDataList.stream().map(each -> new ShardingSphereTable(each.getName(), this.convertToColumns(each.getColumns()), this.convertToIndexes(each.getIndexes()), this.convertToConstraints(each.getConstraints()), each.getType())).collect(Collectors.toList());
    }

    private Collection<ShardingSphereColumn> convertToColumns(Collection<ColumnMetaData> columnMetaDataList) {
        return columnMetaDataList.stream().map(ShardingSphereColumn::new).collect(Collectors.toList());
    }

    private Collection<ShardingSphereIndex> convertToIndexes(Collection<IndexMetaData> indexMetaDataList) {
        return indexMetaDataList.stream().map(ShardingSphereIndex::new).collect(Collectors.toList());
    }

    private Collection<ShardingSphereConstraint> convertToConstraints(Collection<ConstraintMetaData> constraintMetaDataList) {
        return constraintMetaDataList.stream().map(ShardingSphereConstraint::new).collect(Collectors.toList());
    }

    @Generated
    public MetaDataReviseEngine(Collection<ShardingSphereRule> rules) {
        this.rules = rules;
    }
}

