/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.node.path.rule.item;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.mode.node.path.rule.root.RuleRootNodePath;

public final class UniqueRuleItemNodePath {
    private static final String VERSIONS = "/versions/\\d+$";
    private static final String ACTIVE_VERSION = "/active_version$";
    private final String parentNode;
    private final String type;
    private final Pattern pathPattern;
    private final Pattern activeVersionPathPattern;

    public UniqueRuleItemNodePath(RuleRootNodePath ruleRootNodePath, String type) {
        this.parentNode = null;
        this.type = type;
        this.pathPattern = Pattern.compile(ruleRootNodePath.getNodePrefix() + type + VERSIONS);
        this.activeVersionPathPattern = Pattern.compile(ruleRootNodePath.getNodePrefix() + type + ACTIVE_VERSION);
    }

    public UniqueRuleItemNodePath(RuleRootNodePath ruleRootNodePath, String parentNode, String type) {
        this.parentNode = parentNode;
        this.type = type;
        this.pathPattern = Pattern.compile(ruleRootNodePath.getNodePrefix() + parentNode + "/" + type + VERSIONS);
        this.activeVersionPathPattern = Pattern.compile(ruleRootNodePath.getNodePrefix() + parentNode + "/" + type + ACTIVE_VERSION);
    }

    public String getPath() {
        return null == this.parentNode ? String.join((CharSequence)"/", this.type) : String.join((CharSequence)"/", this.parentNode, this.type);
    }

    public boolean isValidatedPath(String path) {
        return this.pathPattern.matcher(path).find();
    }

    public boolean isActiveVersionPath(String path) {
        Matcher matcher = this.activeVersionPathPattern.matcher(path);
        return matcher.find();
    }
}

