/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.core.recorder;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.agent.api.advice.AgentAdvice;
import org.apache.shardingsphere.agent.api.advice.TargetAdviceMethod;

public final class MethodTimeRecorder {
    private static final ThreadLocal<Map<String, Long>> CURRENT_RECORDER = ThreadLocal.withInitial(HashMap::new);
    private final Class<? extends AgentAdvice> adviceClass;

    public void recordNow(TargetAdviceMethod method) {
        CURRENT_RECORDER.get().put(this.getKey(method), System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getElapsedTimeAndClean(TargetAdviceMethod method) {
        String key = this.getKey(method);
        try {
            long l = this.getElapsedTime(key);
            return l;
        }
        finally {
            this.clean(key);
        }
    }

    private String getKey(TargetAdviceMethod method) {
        return String.format("%s@%s", this.adviceClass.getName(), method.getName());
    }

    private long getElapsedTime(String key) {
        return CURRENT_RECORDER.get().containsKey(key) ? System.currentTimeMillis() - CURRENT_RECORDER.get().get(key) : 0L;
    }

    private void clean(String key) {
        CURRENT_RECORDER.get().remove(key);
        if (CURRENT_RECORDER.get().isEmpty()) {
            CURRENT_RECORDER.remove();
        }
    }

    @Generated
    public MethodTimeRecorder(Class<? extends AgentAdvice> adviceClass) {
        this.adviceClass = adviceClass;
    }
}

