/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.core.ack;

import com.google.common.base.Splitter;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.RandomStringUtils;

public final class CDCAckId {
    private final String importerId;
    private final String random;

    public static CDCAckId build(String importerId) {
        return new CDCAckId(importerId, RandomStringUtils.randomAlphanumeric((int)16));
    }

    public String marshal() {
        return this.importerId + "_" + this.random;
    }

    public static CDCAckId unmarshal(String text) {
        List parts = Splitter.on((char)'_').trimResults().omitEmptyStrings().splitToList((CharSequence)text);
        return new CDCAckId((String)parts.get(0), (String)parts.get(1));
    }

    @Generated
    public CDCAckId(String importerId, String random) {
        this.importerId = importerId;
        this.random = random;
    }

    @Generated
    public String getImporterId() {
        return this.importerId;
    }

    @Generated
    public String getRandom() {
        return this.random;
    }
}

