/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineIndexMetaData;
import org.apache.shardingsphere.infra.metadata.identifier.ShardingSphereIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineTableMetaData {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineTableMetaData.class);
    @NonNull
    private final String name;
    private final Map<ShardingSphereIdentifier, PipelineColumnMetaData> columnMetaDataMap;
    private final List<String> columnNames;
    private final List<String> primaryKeyColumns;
    private final Collection<PipelineIndexMetaData> uniqueIndexes;

    public PipelineTableMetaData(String name, Map<ShardingSphereIdentifier, PipelineColumnMetaData> columnMetaDataMap, Collection<PipelineIndexMetaData> uniqueIndexes) {
        this.name = name;
        this.columnMetaDataMap = columnMetaDataMap;
        ArrayList<PipelineColumnMetaData> columnMetaDataList = new ArrayList<PipelineColumnMetaData>(columnMetaDataMap.values());
        Collections.sort(columnMetaDataList);
        this.columnNames = Collections.unmodifiableList(columnMetaDataList.stream().map(PipelineColumnMetaData::getName).collect(Collectors.toList()));
        Optional<PipelineIndexMetaData> primaryKeyMetaData = uniqueIndexes.stream().filter(PipelineIndexMetaData::isPrimaryKey).findFirst();
        this.primaryKeyColumns = primaryKeyMetaData.map(each -> each.getColumns().stream().map(PipelineColumnMetaData::getName).collect(Collectors.toList())).orElseGet(() -> Collections.unmodifiableList(columnMetaDataList.stream().filter(PipelineColumnMetaData::isPrimaryKey).map(PipelineColumnMetaData::getName).collect(Collectors.toList())));
        this.uniqueIndexes = Collections.unmodifiableCollection(uniqueIndexes);
    }

    public PipelineColumnMetaData getColumnMetaData(int columnIndex) {
        return this.getColumnMetaData(this.columnNames.get(columnIndex - 1));
    }

    public PipelineColumnMetaData getColumnMetaData(String columnName) {
        PipelineColumnMetaData result = this.columnMetaDataMap.get(new ShardingSphereIdentifier(columnName));
        if (null == result) {
            log.warn("Can not get column meta data for column name '{}', columnNames={}", (Object)columnName, this.columnNames);
        }
        return result;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PipelineTableMetaData)) {
            return false;
        }
        PipelineTableMetaData other = (PipelineTableMetaData)o;
        String this$name = this.name;
        String other$name = other.name;
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PipelineTableMetaData(name=" + this.name + ", columnMetaDataMap=" + this.columnMetaDataMap + ", columnNames=" + this.getColumnNames() + ", primaryKeyColumns=" + this.getPrimaryKeyColumns() + ", uniqueIndexes=" + this.getUniqueIndexes() + ")";
    }

    @Generated
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Generated
    public List<String> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    @Generated
    public Collection<PipelineIndexMetaData> getUniqueIndexes() {
        return this.uniqueIndexes;
    }
}

