/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.persist.service.unified;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.ComputeNodeData;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaDataFactory;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.instance.yaml.YamlComputeNodeData;
import org.apache.shardingsphere.infra.instance.yaml.YamlComputeNodeDataSwapper;
import org.apache.shardingsphere.infra.state.instance.InstanceState;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.node.path.metadata.ComputeNodePath;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComputeNodePersistService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComputeNodePersistService.class);
    private final PersistRepository repository;

    public void registerOnline(ComputeNodeInstance computeNodeInstance) {
        this.persistOnline(computeNodeInstance);
        this.updateState(computeNodeInstance.getMetaData().getId(), computeNodeInstance.getState().getCurrentState());
        this.persistLabels(computeNodeInstance.getMetaData().getId(), computeNodeInstance.getLabels());
    }

    private void persistOnline(ComputeNodeInstance computeNodeInstance) {
        ComputeNodeData computeNodeData = new ComputeNodeData(computeNodeInstance.getMetaData().getDatabaseName(), computeNodeInstance.getMetaData().getAttributes(), computeNodeInstance.getMetaData().getVersion());
        this.repository.persistEphemeral(ComputeNodePath.getOnlinePath((String)computeNodeInstance.getMetaData().getId(), (InstanceType)computeNodeInstance.getMetaData().getType()), YamlEngine.marshal((Object)new YamlComputeNodeDataSwapper().swapToYamlConfiguration(computeNodeData)));
    }

    public void offline(ComputeNodeInstance computeNodeInstance) {
        this.repository.delete(ComputeNodePath.getOnlinePath((String)computeNodeInstance.getMetaData().getId(), (InstanceType)computeNodeInstance.getMetaData().getType()));
    }

    public Collection<ComputeNodeInstance> loadAllInstances() {
        return Arrays.stream(InstanceType.values()).flatMap(each -> this.loadInstances((InstanceType)each).stream()).collect(Collectors.toList());
    }

    private Collection<ComputeNodeInstance> loadInstances(InstanceType instanceType) {
        LinkedList<ComputeNodeInstance> result = new LinkedList<ComputeNodeInstance>();
        for (String each : this.repository.getChildrenKeys(ComputeNodePath.getOnlinePath((InstanceType)instanceType))) {
            String value = this.repository.query(ComputeNodePath.getOnlinePath((String)each, (InstanceType)instanceType));
            if (Strings.isNullOrEmpty((String)value)) continue;
            ComputeNodeData computeNodeData = new YamlComputeNodeDataSwapper().swapToObject((YamlComputeNodeData)YamlEngine.unmarshal((String)value, YamlComputeNodeData.class));
            result.add(this.loadInstance(InstanceMetaDataFactory.create((String)each, (InstanceType)instanceType, (ComputeNodeData)computeNodeData)));
        }
        return result;
    }

    public ComputeNodeInstance loadInstance(InstanceMetaData instanceMetaData) {
        ComputeNodeInstance result = new ComputeNodeInstance(instanceMetaData);
        InstanceState.get((String)this.loadState(instanceMetaData.getId())).ifPresent(arg_0 -> ((ComputeNodeInstance)result).switchState(arg_0));
        result.getLabels().addAll(this.loadLabels(instanceMetaData.getId()));
        this.loadWorkerId(instanceMetaData.getId()).ifPresent(arg_0 -> ((ComputeNodeInstance)result).setWorkerId(arg_0));
        return result;
    }

    private String loadState(String instanceId) {
        return this.repository.query(ComputeNodePath.getStatePath((String)instanceId));
    }

    private Collection<String> loadLabels(String instanceId) {
        String yamlContent = this.repository.query(ComputeNodePath.getLabelsPath((String)instanceId));
        return Strings.isNullOrEmpty((String)yamlContent) ? Collections.emptyList() : (Collection)YamlEngine.unmarshal((String)yamlContent, Collection.class);
    }

    public void updateState(String instanceId, InstanceState instanceState) {
        this.repository.persistEphemeral(ComputeNodePath.getStatePath((String)instanceId), instanceState.name());
    }

    public void persistLabels(String instanceId, Collection<String> labels) {
        this.repository.persistEphemeral(ComputeNodePath.getLabelsPath((String)instanceId), YamlEngine.marshal(labels));
    }

    public void persistWorkerId(String instanceId, int workerId) {
        this.repository.persistEphemeral(ComputeNodePath.getWorkerIdPath((String)instanceId), String.valueOf(workerId));
    }

    public Optional<Integer> loadWorkerId(String instanceId) {
        try {
            String workerId = this.repository.query(ComputeNodePath.getWorkerIdPath((String)instanceId));
            return Strings.isNullOrEmpty((String)workerId) ? Optional.empty() : Optional.of(Integer.valueOf(workerId));
        }
        catch (NumberFormatException ex) {
            log.error("Invalid worker id for instance: {}", (Object)instanceId);
            return Optional.empty();
        }
    }

    public Collection<Integer> getAssignedWorkerIds() {
        List instanceIds = this.repository.getChildrenKeys(ComputeNodePath.getWorkerIdRootPath());
        return instanceIds.stream().map(each -> this.repository.query(ComputeNodePath.getWorkerIdPath((String)each))).filter(Objects::nonNull).map(Integer::parseInt).collect(Collectors.toSet());
    }

    @Generated
    public ComputeNodePersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

