/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.sql.SQLException;
import org.apache.openjpa.jdbc.kernel.exps.AbstractVal;
import org.apache.openjpa.jdbc.kernel.exps.Args;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.meta.ClassMetaData;

abstract class UnaryOp
extends AbstractVal {
    private static final long serialVersionUID = 1L;
    private final Val _val;
    private ClassMetaData _meta = null;
    private Class _cast = null;
    private boolean _noParen = false;

    public UnaryOp(Val val) {
        this._val = val;
    }

    public UnaryOp(Val val, boolean noParen) {
        this._val = val;
        this._noParen = noParen;
    }

    public Val getValue() {
        return this._val;
    }

    @Override
    public ClassMetaData getMetaData() {
        return this._meta;
    }

    @Override
    public void setMetaData(ClassMetaData meta) {
        this._meta = meta;
    }

    @Override
    public Class getType() {
        if (this._cast != null) {
            return this._cast;
        }
        return this.getType(this._val.getType());
    }

    @Override
    public void setImplicitType(Class type) {
        this._cast = type;
    }

    public boolean getNoParen() {
        return this._noParen;
    }

    @Override
    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        return this.initializeValue(sel, ctx, flags);
    }

    protected ExpState initializeValue(Select sel, ExpContext ctx, int flags) {
        return this._val.initialize(sel, ctx, flags);
    }

    @Override
    public void select(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        sel.select(this.newSQLBuffer(sel, ctx, state), (Object)this);
        if (this.isAggregate()) {
            sel.setAggregate(true);
        }
    }

    @Override
    public void selectColumns(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        this._val.selectColumns(sel, ctx, state, true);
    }

    @Override
    public void groupBy(Select sel, ExpContext ctx, ExpState state) {
        sel.groupBy(this.newSQLBuffer(sel, ctx, state));
    }

    @Override
    public void orderBy(Select sel, ExpContext ctx, ExpState state, boolean asc) {
        sel.orderBy(this.newSQLBuffer(sel, ctx, state), asc, false, this.getSelectAs());
    }

    private SQLBuffer newSQLBuffer(Select sel, ExpContext ctx, ExpState state) {
        this.calculateValue(sel, ctx, state, null, null);
        SQLBuffer buf = new SQLBuffer(ctx.store.getDBDictionary());
        this.appendTo(sel, ctx, state, buf, 0);
        return buf;
    }

    @Override
    public Object load(ExpContext ctx, ExpState state, Result res) throws SQLException {
        Object value = res.getObject(this, 1012, null);
        Class type = this.getType();
        if (value == null) {
            if (this.nullableValue(ctx, state)) {
                return null;
            }
            if (type.isPrimitive() || Number.class.isAssignableFrom(type)) {
                value = Filters.getDefaultForNull(Filters.wrap(type));
            }
        }
        return Filters.convert(value, type);
    }

    @Override
    public void calculateValue(Select sel, ExpContext ctx, ExpState state, Val other, ExpState otherState) {
        this._val.calculateValue(sel, ctx, state, null, null);
    }

    @Override
    public int length(Select sel, ExpContext ctx, ExpState state) {
        return 1;
    }

    @Override
    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql2, int index) {
        sql2.append(this.getOperator());
        sql2.append(this._noParen ? " " : "(");
        this._val.appendTo(sel, ctx, state, sql2, 0);
        sql2.addCastForParam(this.getOperator(), this._val instanceof Args ? ((Args)this._val).getVals()[0] : this._val);
        if (!this._noParen) {
            sql2.append(")");
        }
    }

    protected Class getType(Class c) {
        return c;
    }

    protected abstract String getOperator();

    @Override
    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter(this);
        this._val.acceptVisit(visitor);
        visitor.exit(this);
    }

    protected boolean nullableValue(ExpContext ctx, ExpState state) {
        return false;
    }
}

