/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.config;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.orm.jpa.JpaBaseConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.OpenJpaVendorAdapter;
import org.springframework.transaction.jta.JtaTransactionManager;

@Configuration
@EnableConfigurationProperties(value={JpaProperties.class})
public class OpenJPAConfig
extends JpaBaseConfiguration {
    protected OpenJPAConfig(DataSource dataSource, JpaProperties properties, ObjectProvider<JtaTransactionManager> jtaTransactionManager, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        super(dataSource, properties, jtaTransactionManager, transactionManagerCustomizers);
    }

    protected AbstractJpaVendorAdapter createJpaVendorAdapter() {
        return new OpenJpaVendorAdapter();
    }

    protected Map<String, Object> getVendorProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
        result.put("openjpa.ClassLoadEnhancement", "false");
        result.put("openjpa.DynamicEnhancementAgent", "false");
        result.put("openjpa.RuntimeUnenhancedClasses", "supported");
        result.put("openjpa.Log", "slf4j");
        return result;
    }
}

