/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.security;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.google.common.base.Strings;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.shardingsphere.elasticjob.cloud.ui.security.AuthenticationResult;
import org.apache.shardingsphere.elasticjob.cloud.ui.security.UserAccount;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="auth")
public final class UserAuthenticationService {
    private static final String JWT_TOKEN_ISSUER = "shardingsphere-elasticjob-ui";
    private final Algorithm algorithm = Algorithm.HMAC256((String)RandomStringUtils.randomAlphanumeric((int)256));
    private final JWTVerifier verifier = JWT.require((Algorithm)this.algorithm).withIssuer("shardingsphere-elasticjob-ui").build();
    private String username;
    private String password;
    private int tokenExpiresAfterSeconds = 3600;

    public AuthenticationResult checkUser(UserAccount userAccount) {
        if (null == userAccount || Strings.isNullOrEmpty((String)userAccount.getUsername()) || Strings.isNullOrEmpty((String)userAccount.getPassword())) {
            return new AuthenticationResult(null, null, false);
        }
        if (this.username.equals(userAccount.getUsername()) && this.password.equals(userAccount.getPassword())) {
            return new AuthenticationResult(this.username, this.password, true);
        }
        return new AuthenticationResult(null, null, false);
    }

    public String getToken(String username) {
        HashMap<String, String> payload = new HashMap<String, String>(1, 1.0f);
        payload.put("username", username);
        Date expiresAt = new Date(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.tokenExpiresAfterSeconds));
        return JWT.create().withExpiresAt(expiresAt).withIssuer(JWT_TOKEN_ISSUER).withPayload(payload).sign(this.algorithm);
    }

    public boolean isValidToken(String token) {
        try {
            this.verifier.verify(token);
        }
        catch (JWTVerificationException ignored) {
            return false;
        }
        return true;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTokenExpiresAfterSeconds(int tokenExpiresAfterSeconds) {
        this.tokenExpiresAfterSeconds = tokenExpiresAfterSeconds;
    }
}

