/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.service.app;

public final class CloudAppConfiguration {
    private final String appName;
    private final String appURL;
    private final String bootstrapScript;
    private double cpuCount = 1.0;
    private double memoryMB = 128.0;
    private boolean appCacheEnable = true;
    private int eventTraceSamplingCount;

    public CloudAppConfiguration(String appName, String appURL, String bootstrapScript, double cpuCount, double memoryMB, boolean appCacheEnable, int eventTraceSamplingCount) {
        this.appName = appName;
        this.appURL = appURL;
        this.bootstrapScript = bootstrapScript;
        this.cpuCount = cpuCount;
        this.memoryMB = memoryMB;
        this.appCacheEnable = appCacheEnable;
        this.eventTraceSamplingCount = eventTraceSamplingCount;
    }

    public CloudAppConfiguration(String appName, String appURL, String bootstrapScript) {
        this.appName = appName;
        this.appURL = appURL;
        this.bootstrapScript = bootstrapScript;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppURL() {
        return this.appURL;
    }

    public String getBootstrapScript() {
        return this.bootstrapScript;
    }

    public double getCpuCount() {
        return this.cpuCount;
    }

    public double getMemoryMB() {
        return this.memoryMB;
    }

    public boolean isAppCacheEnable() {
        return this.appCacheEnable;
    }

    public int getEventTraceSamplingCount() {
        return this.eventTraceSamplingCount;
    }

    public String toString() {
        return "CloudAppConfiguration(appName=" + this.getAppName() + ", appURL=" + this.getAppURL() + ", bootstrapScript=" + this.getBootstrapScript() + ", cpuCount=" + this.getCpuCount() + ", memoryMB=" + this.getMemoryMB() + ", appCacheEnable=" + this.isAppCacheEnable() + ", eventTraceSamplingCount=" + this.getEventTraceSamplingCount() + ")";
    }
}

