/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.service.state.ready;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.elasticjob.cloud.config.CloudJobExecutionType;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.ui.config.JobStateConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.job.CloudJobConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.state.ready.ReadyNode;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class ReadyService {
    private static final Logger log = LoggerFactory.getLogger(ReadyService.class);
    @Autowired
    private CoordinatorRegistryCenter regCenter;
    @Autowired
    private CloudJobConfigurationService configService;
    @Autowired
    private JobStateConfiguration jobStateConfiguration;

    public void addTransient(String jobName) {
        if (this.regCenter.getNumChildren("/state/ready") > this.jobStateConfiguration.getQueueSize()) {
            log.warn("Cannot add transient job, caused by read state queue size is larger than {}.", (Object)this.jobStateConfiguration.getQueueSize());
            return;
        }
        Optional<CloudJobConfigurationPOJO> cloudJobConfig = this.configService.load(jobName);
        if (!cloudJobConfig.isPresent() || CloudJobExecutionType.TRANSIENT != cloudJobConfig.get().getJobExecutionType()) {
            return;
        }
        String readyJobNode = ReadyNode.getReadyJobNodePath(jobName);
        String times = this.regCenter.getDirectly(readyJobNode);
        if (cloudJobConfig.get().isMisfire()) {
            this.regCenter.persist(readyJobNode, Integer.toString(null == times ? 1 : Integer.parseInt(times) + 1));
        } else {
            this.regCenter.persist(ReadyNode.getReadyJobNodePath(jobName), "1");
        }
    }

    public Map<String, Integer> getAllReadyTasks() {
        if (!this.regCenter.isExisted("/state/ready")) {
            return Collections.emptyMap();
        }
        List jobNames = this.regCenter.getChildrenKeys("/state/ready");
        HashMap<String, Integer> result = new HashMap<String, Integer>(jobNames.size(), 1.0f);
        for (String each : jobNames) {
            String times = this.regCenter.get(ReadyNode.getReadyJobNodePath(each));
            if (Strings.isNullOrEmpty((String)times)) continue;
            result.put(each, Integer.parseInt(times));
        }
        return result;
    }
}

