/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.web.controller;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.ui.exception.AppConfigurationException;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.app.CloudAppConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.app.pojo.CloudAppConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.job.CloudJobConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.producer.ProducerManager;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.state.disable.app.DisableAppService;
import org.apache.shardingsphere.elasticjob.cloud.ui.web.dto.CloudAppConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.ui.web.response.ResponseResult;
import org.apache.shardingsphere.elasticjob.cloud.ui.web.response.ResponseResultUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/app"})
public final class CloudAppController {
    @Autowired
    private ProducerManager producerManager;
    @Autowired
    private CloudAppConfigurationService appConfigService;
    @Autowired
    private DisableAppService disableAppService;
    @Autowired
    private CloudJobConfigurationService jobConfigService;

    @PostMapping(value={"/register"})
    public ResponseResult register(@RequestBody CloudAppConfigurationPOJO appConfig) {
        Optional<CloudAppConfigurationPOJO> appConfigFromZk = this.appConfigService.load(appConfig.getAppName());
        if (appConfigFromZk.isPresent()) {
            throw new AppConfigurationException("app '%s' already existed.", appConfig.getAppName());
        }
        this.appConfigService.add(appConfig);
        return ResponseResultUtil.success();
    }

    @PostMapping(value={"/update"})
    public ResponseResult update(@RequestBody CloudAppConfigurationPOJO appConfig) {
        this.appConfigService.update(appConfig);
        return ResponseResultUtil.success();
    }

    @GetMapping(value={"/{appName}"})
    public ResponseResult<CloudAppConfigurationPOJO> detail(@PathVariable(value="appName") String appName) {
        Optional<CloudAppConfigurationPOJO> appConfig = this.appConfigService.load(appName);
        return ResponseResultUtil.build(appConfig.orElse(null));
    }

    @GetMapping(value={"/list"})
    public ResponseResult<Collection<CloudAppConfiguration>> findAllApps() {
        return ResponseResultUtil.build(this.build(this.appConfigService.loadAll()));
    }

    @GetMapping(value={"/{appName}/disable"})
    public boolean isDisabled(@PathVariable(value="appName") String appName) {
        return this.disableAppService.isDisabled(appName);
    }

    @PostMapping(value={"/{appName}/disable"})
    public ResponseResult disable(@PathVariable(value="appName") String appName) {
        if (this.appConfigService.load(appName).isPresent()) {
            this.disableAppService.add(appName);
        }
        return ResponseResultUtil.success();
    }

    @PostMapping(value={"/{appName}/enable"})
    public ResponseResult enable(@PathVariable(value="appName") String appName) {
        if (this.appConfigService.load(appName).isPresent()) {
            this.disableAppService.remove(appName);
        }
        return ResponseResultUtil.success();
    }

    @DeleteMapping(value={"/{appName}"})
    public ResponseResult deregister(@PathVariable(value="appName") String appName) {
        if (this.appConfigService.load(appName).isPresent()) {
            this.removeAppAndJobConfigurations(appName);
        }
        return ResponseResultUtil.success();
    }

    private void removeAppAndJobConfigurations(String appName) {
        for (CloudJobConfigurationPOJO each : this.jobConfigService.loadAll()) {
            if (!appName.equals(each.getAppName())) continue;
            this.producerManager.deregister(each.getJobName());
        }
        this.disableAppService.remove(appName);
        this.appConfigService.remove(appName);
    }

    private Collection<CloudAppConfiguration> build(Collection<CloudAppConfigurationPOJO> cloudAppConfigurationPOJOS) {
        return cloudAppConfigurationPOJOS.stream().map(each -> this.convert((CloudAppConfigurationPOJO)each)).collect(Collectors.toList());
    }

    private CloudAppConfiguration convert(CloudAppConfigurationPOJO cloudAppConfigurationPOJO) {
        CloudAppConfiguration cloudAppConfiguration = new CloudAppConfiguration();
        BeanUtils.copyProperties((Object)cloudAppConfigurationPOJO, (Object)cloudAppConfiguration);
        cloudAppConfiguration.setDisabled(this.disableAppService.isDisabled(cloudAppConfigurationPOJO.getAppName()));
        return cloudAppConfiguration;
    }
}

