/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;
import org.aspectj.apache.bcel.classfile.annotation.NameValuePair;
import org.aspectj.apache.bcel.generic.ObjectType;

public class AnnotationGen {
    public static final AnnotationGen[] NO_ANNOTATIONS = new AnnotationGen[0];
    private int typeIndex;
    private List<NameValuePair> pairs = Collections.emptyList();
    private ConstantPool cpool;
    private boolean isRuntimeVisible = false;

    public AnnotationGen(AnnotationGen annotationGen, ConstantPool constantPool, boolean bl) {
        this.cpool = constantPool;
        this.typeIndex = bl ? constantPool.addUtf8(annotationGen.getTypeSignature()) : annotationGen.getTypeIndex();
        this.isRuntimeVisible = annotationGen.isRuntimeVisible();
        this.pairs = this.copyValues(annotationGen.getValues(), constantPool, bl);
    }

    private List<NameValuePair> copyValues(List<NameValuePair> list, ConstantPool constantPool, boolean bl) {
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        for (NameValuePair nameValuePair : list) {
            arrayList.add(new NameValuePair(nameValuePair, constantPool, bl));
        }
        return arrayList;
    }

    private AnnotationGen(ConstantPool constantPool) {
        this.cpool = constantPool;
    }

    public AnnotationGen(ObjectType objectType, List<NameValuePair> list, boolean bl, ConstantPool constantPool) {
        this.cpool = constantPool;
        if (objectType != null) {
            this.typeIndex = constantPool.addUtf8(objectType.getSignature());
        }
        this.pairs = list;
        this.isRuntimeVisible = bl;
    }

    public static AnnotationGen read(DataInputStream dataInputStream, ConstantPool constantPool, boolean bl) throws IOException {
        AnnotationGen annotationGen = new AnnotationGen(constantPool);
        annotationGen.typeIndex = dataInputStream.readUnsignedShort();
        int n = dataInputStream.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readUnsignedShort();
            annotationGen.addElementNameValuePair(new NameValuePair(n2, ElementValue.readElementValue(dataInputStream, constantPool), constantPool));
        }
        annotationGen.isRuntimeVisible(bl);
        return annotationGen;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.typeIndex);
        dataOutputStream.writeShort(this.pairs.size());
        for (int i = 0; i < this.pairs.size(); ++i) {
            NameValuePair nameValuePair = this.pairs.get(i);
            nameValuePair.dump(dataOutputStream);
        }
    }

    public void addElementNameValuePair(NameValuePair nameValuePair) {
        if (this.pairs == Collections.EMPTY_LIST) {
            this.pairs = new ArrayList<NameValuePair>();
        }
        this.pairs.add(nameValuePair);
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public String getTypeSignature() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpool.getConstant(this.typeIndex);
        return constantUtf8.getValue();
    }

    public String getTypeName() {
        return Utility.signatureToString(this.getTypeSignature());
    }

    public List<NameValuePair> getValues() {
        return this.pairs;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AnnotationGen:[" + this.getTypeName() + " #" + this.pairs.size() + " {");
        for (int i = 0; i < this.pairs.size(); ++i) {
            stringBuffer.append(this.pairs.get(i));
            if (i + 1 >= this.pairs.size()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}]");
        return stringBuffer.toString();
    }

    public String toShortString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("@").append(this.getTypeName());
        if (this.pairs.size() != 0) {
            stringBuffer.append("(");
            for (int i = 0; i < this.pairs.size(); ++i) {
                stringBuffer.append(this.pairs.get(i));
                if (i + 1 >= this.pairs.size()) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private void isRuntimeVisible(boolean bl) {
        this.isRuntimeVisible = bl;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    public boolean hasNameValuePair(String string, String string2) {
        for (NameValuePair nameValuePair : this.pairs) {
            if (!nameValuePair.getNameString().equals(string) || !nameValuePair.getValue().stringifyValue().equals(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNamedValue(String string) {
        for (NameValuePair nameValuePair : this.pairs) {
            if (!nameValuePair.getNameString().equals(string)) continue;
            return true;
        }
        return false;
    }
}

