/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;

public abstract class RuntimeAnnos
extends Attribute {
    private List<AnnotationGen> annotations;
    private boolean visible;
    private boolean inflated = false;
    private byte[] annotation_data;

    public RuntimeAnnos(byte by, boolean bl, int n, int n2, ConstantPool constantPool) {
        super(by, n, n2, constantPool);
        this.visible = bl;
        this.annotations = new ArrayList<AnnotationGen>();
    }

    public RuntimeAnnos(byte by, boolean bl, int n, int n2, byte[] byArray, ConstantPool constantPool) {
        super(by, n, n2, constantPool);
        this.visible = bl;
        this.annotations = new ArrayList<AnnotationGen>();
        this.annotation_data = byArray;
    }

    public List<AnnotationGen> getAnnotations() {
        if (!this.inflated) {
            this.inflate();
        }
        return this.annotations;
    }

    public boolean areVisible() {
        return this.visible;
    }

    protected void readAnnotations(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this.annotation_data = new byte[this.length];
        dataInputStream.readFully(this.annotation_data, 0, this.length);
    }

    protected void writeAnnotations(DataOutputStream dataOutputStream) throws IOException {
        if (!this.inflated) {
            dataOutputStream.write(this.annotation_data, 0, this.length);
        } else {
            dataOutputStream.writeShort(this.annotations.size());
            for (AnnotationGen annotationGen : this.annotations) {
                annotationGen.dump(dataOutputStream);
            }
        }
    }

    private void inflate() {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.annotation_data));
            int n = dataInputStream.readUnsignedShort();
            if (n > 0) {
                ArrayList<AnnotationGen> arrayList = new ArrayList<AnnotationGen>();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(AnnotationGen.read(dataInputStream, this.getConstantPool(), this.visible));
                }
                this.annotations = arrayList;
            }
            dataInputStream.close();
            this.inflated = true;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unabled to inflate annotation data, badly formed? ");
        }
    }

    public boolean isInflated() {
        return this.inflated;
    }
}

