/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.ui.web.controller;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.domain.JobBriefInfo;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.domain.ServerBriefInfo;
import org.apache.shardingsphere.elasticjob.lite.ui.service.JobAPIService;
import org.apache.shardingsphere.elasticjob.lite.ui.util.SessionRegistryCenterConfiguration;
import org.apache.shardingsphere.elasticjob.lite.ui.web.response.ResponseResult;
import org.apache.shardingsphere.elasticjob.lite.ui.web.response.ResponseResultUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/servers"})
public final class ServerOperationController {
    private JobAPIService jobAPIService;

    @Autowired
    public ServerOperationController(JobAPIService jobAPIService) {
        this.jobAPIService = jobAPIService;
    }

    @GetMapping(value={"/count"})
    public int getServersTotalCount() {
        return this.jobAPIService.getServerStatisticsAPI().getServersTotalCount();
    }

    @GetMapping(value={"/getAllServersBriefInfo"})
    public ResponseResult<Collection<ServerBriefInfo>> getAllServersBriefInfo() {
        List data = Objects.nonNull(SessionRegistryCenterConfiguration.getRegistryCenterConfiguration()) ? this.jobAPIService.getServerStatisticsAPI().getAllServersBriefInfo() : Collections.emptyList();
        return ResponseResultUtil.build(data);
    }

    @PostMapping(value={"/{serverIp}/disable"})
    public ResponseResult<Boolean> disableServer(@PathVariable(value="serverIp") String serverIp) {
        this.jobAPIService.getJobOperatorAPI().disable(null, serverIp);
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @PostMapping(value={"/{serverIp}/enable"})
    public ResponseResult<Boolean> enableServer(@PathVariable(value="serverIp") String serverIp) {
        this.jobAPIService.getJobOperatorAPI().enable(null, serverIp);
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @PostMapping(value={"/{serverIp}/shutdown"})
    public ResponseResult<Boolean> shutdownServer(@PathVariable(value="serverIp") String serverIp) {
        this.jobAPIService.getJobOperatorAPI().shutdown(null, serverIp);
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @DeleteMapping(value={"/{serverIp:.+}"})
    public ResponseResult<Boolean> removeServer(@PathVariable(value="serverIp") String serverIp) {
        this.jobAPIService.getJobOperatorAPI().remove(null, serverIp);
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @GetMapping(value={"/{serverIp}/jobs"})
    public ResponseResult<Collection<JobBriefInfo>> getJobs(@PathVariable(value="serverIp") String serverIp) {
        Collection data = this.jobAPIService.getJobStatisticsAPI().getJobsBriefInfo(serverIp);
        return ResponseResultUtil.build(data);
    }

    @PostMapping(value={"/{serverIp}/jobs/{jobName}/disable"})
    public ResponseResult<Boolean> disableServerJob(@PathVariable(value="serverIp") String serverIp, @PathVariable(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().disable(jobName, serverIp);
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @PostMapping(value={"/{serverIp}/jobs/{jobName}/enable"})
    public ResponseResult<Boolean> enableServerJob(@PathVariable(value="serverIp") String serverIp, @PathVariable(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().enable(jobName, serverIp);
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @PostMapping(value={"/{serverIp}/jobs/{jobName}/shutdown"})
    public ResponseResult<Boolean> shutdownServerJob(@PathVariable(value="serverIp") String serverIp, @PathVariable(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().shutdown(jobName, serverIp);
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @DeleteMapping(value={"/{serverIp}/jobs/{jobName:.+}"})
    public ResponseResult<Boolean> removeServerJob(@PathVariable(value="serverIp") String serverIp, @PathVariable(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().remove(jobName, serverIp);
        return ResponseResultUtil.build(Boolean.TRUE);
    }
}

