/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.listener;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.curator.utils.ThreadUtils;

public final class ListenerNotifierManager {
    private static volatile ListenerNotifierManager instance;
    private final Map<String, ExecutorService> listenerNotifyExecutors = new ConcurrentHashMap<String, ExecutorService>();

    private ListenerNotifierManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ListenerNotifierManager getInstance() {
        if (null != instance) return instance;
        Class<ListenerNotifierManager> clazz = ListenerNotifierManager.class;
        synchronized (ListenerNotifierManager.class) {
            if (null != instance) return instance;
            instance = new ListenerNotifierManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerJobNotifyExecutor(String jobName) {
        if (!this.listenerNotifyExecutors.containsKey(jobName)) {
            ListenerNotifierManager listenerNotifierManager = this;
            synchronized (listenerNotifierManager) {
                if (!this.listenerNotifyExecutors.containsKey(jobName)) {
                    ThreadFactory threadFactory = ThreadUtils.newGenericThreadFactory((String)("ListenerNotify-" + jobName));
                    ExecutorService notifyExecutor = Executors.newSingleThreadExecutor(threadFactory);
                    this.listenerNotifyExecutors.put(jobName, notifyExecutor);
                }
            }
        }
    }

    public Executor getJobNotifyExecutor(String jobName) {
        return this.listenerNotifyExecutors.get(jobName);
    }

    public void removeJobNotifyExecutor(String jobName) {
        Optional.ofNullable(this.listenerNotifyExecutors.remove(jobName)).ifPresent(ExecutorService::shutdown);
    }
}

