/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;

public class NameValuePair {
    private int nameIdx;
    private ElementValue value;
    private ConstantPool cpool;

    public NameValuePair(NameValuePair nameValuePair, ConstantPool constantPool, boolean bl) {
        this.cpool = constantPool;
        this.nameIdx = bl ? constantPool.addUtf8(nameValuePair.getNameString()) : nameValuePair.getNameIndex();
        this.value = ElementValue.copy(nameValuePair.getValue(), constantPool, bl);
    }

    protected NameValuePair(int n, ElementValue elementValue, ConstantPool constantPool) {
        this.nameIdx = n;
        this.value = elementValue;
        this.cpool = constantPool;
    }

    public NameValuePair(String string, ElementValue elementValue, ConstantPool constantPool) {
        this.nameIdx = constantPool.addUtf8(string);
        this.value = elementValue;
        this.cpool = constantPool;
    }

    protected void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.nameIdx);
        this.value.dump(dataOutputStream);
    }

    public int getNameIndex() {
        return this.nameIdx;
    }

    public final String getNameString() {
        return this.cpool.getConstantUtf8(this.nameIdx).getValue();
    }

    public final ElementValue getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getNameString()).append("=").append(this.value.stringifyValue());
        return stringBuffer.toString();
    }
}

