/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;

public class FileUtils {
    public static void dirPathCheck(String dirPath) throws IOException {
        File dirPathFile = new File(dirPath);
        try {
            if (!dirPathFile.exists() && !dirPathFile.mkdirs()) {
                throw new IOException(String.format("fail to create dir %s", dirPathFile));
            }
            if (!Files.isWritable(FileSystems.getDefault().getPath(dirPath, new String[0]))) {
                throw new IOException(String.format("fail to check permission for dir %s", dirPath));
            }
        }
        catch (Throwable e) {
            throw new IOException(String.format("fail to check permission for dir %s", dirPathFile), e);
        }
    }
}

