/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.protocol.tcp.connection;

import java.time.Duration;
import java.util.Properties;
import org.apache.shenyu.protocol.tcp.connection.ActivityConnectionObserver;
import org.apache.shenyu.protocol.tcp.connection.ClientConnectionConfigProvider;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.tcp.TcpClient;

public class ConnectionContext {
    private final ClientConnectionConfigProvider connectionConfigProvider;
    private ConnectionProvider connectionProvider;

    public ConnectionContext(ClientConnectionConfigProvider connectionConfigProvider) {
        this.connectionConfigProvider = connectionConfigProvider;
    }

    public void init(Properties props) {
        String tcpProxyClientName = "shenyu-tcp-connection-pool-client";
        String maxConnections = props.getProperty("clientMaxConnections", "20");
        String maxIdleTimeMs = props.getProperty("clientMaxIdleTimeMs", "30000");
        String maxLifeTimeMs = props.getProperty("clientMaxLifeTimeMs", "60000");
        String pendingAcquireTimeout = props.getProperty("clientPendingAcquireTimeout", "5");
        String pendingAcquireMaxCount = props.getProperty("clientPendingAcquireMaxCount", "5");
        this.connectionProvider = ((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)"shenyu-tcp-connection-pool-client").maxConnections(Integer.parseInt(maxConnections))).pendingAcquireTimeout(Duration.ofSeconds(Integer.parseInt(pendingAcquireTimeout)))).pendingAcquireMaxCount(Integer.parseInt(pendingAcquireMaxCount))).maxIdleTime(Duration.ofMillis(Integer.parseInt(maxIdleTimeMs)))).maxLifeTime(Duration.ofMillis(Integer.parseInt(maxLifeTimeMs)))).build();
    }

    public Mono<Connection> getTcpClientConnection(String ip, ActivityConnectionObserver observer) {
        return Mono.just((Object)this.connectionConfigProvider.getProxiedService(ip)).flatMap(url -> TcpClient.create((ConnectionProvider)this.connectionProvider).host(url.getHost()).port(url.getPort()).observe((ConnectionObserver)observer).connect());
    }
}

